<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly
?>
<div class="<?php $this->rootClasses() ?>">
	<div
		class="<?php echo esc_attr( $this->bemSub( 'wrapper' ) ) ?> <?php echo esc_attr( $this->attribute( 'hasBorder' ) ? $this->bemSub( 'has-border' ) : "" ) ?> <?php echo esc_attr( $this->attribute( 'hasBorder' ) ) ?>">
		<?php echo wp_get_attachment_image( $this->attribute( "imageId" ) ); ?>
		<h<?php echo esc_attr($this->getAttribute('headingLevel')) ?> class="<?php echo esc_attr( $this->bemSub( 'stat-wrapper' ) ) ?>
			<?php echo $this->attribute( "statStyle" ) ?>">
			<span><?php echo $this->getAttribute( "preStat" ) ?></span>
			<span class="<?php echo esc_attr( $this->bemSub( 'stat' ) ) ?>"
			      data-fndry-js="stat" data-stat="<?php echo $this->getAttribute( "stat" ) ?>">0</span>
			<span><?php echo $this->getAttribute( "postStat" ) ?></span>
		</h<?php echo esc_attr($this->getAttribute('headingLevel')) ?>>
		<div class="<?php echo esc_attr( $this->bemSub( 'content' ) ) ?>">
			<div
				class="<?php echo esc_attr( $this->bemSub( 'body' ) ) ?> <?php echo esc_attr( $this->attribute( "textStyle" ) ) ?>">
				<?php echo wp_kses_post( $this->getAttribute( "body" ) ) ?>
			</div>
		</div>
	</div>
</div>
