<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
$open_in_new_tab = $this->getContext( 'openInNewTab' );

$service = $this->getAttribute( 'service' ) ?: 'Icon';
$isShare = $this->getAttribute( 'isShare' );
$url     = null;

if ( $isShare ) {
	$current_url   = get_permalink();
	$current_title = get_the_title();
	$bsky_text = rawurlencode( "Currently reading {$current_title} {$current_url}" );
	$shareUrls     = [
		'facebook' => "https://www.facebook.com/sharer/sharer.php?u={$current_url}",
		'twitter'  => "https://twitter.com/intent/tweet?text=Currently reading $current_title;url=$current_url",
		'linkedin' => "https://www.linkedin.com/cws/share?url={$current_url}",
		'pinterest' => "https://pinterest.com/pin/create/button/?url={$current_url}&description={$current_title}",
		'bluesky'   => "https://bsky.app/intent/compose?text={$bsky_text}",
	];

	if ( isset( $shareUrls[ $service ] ) ) {
		$url = $shareUrls[ $service ];
	}
} else {
	$url = $this->getAttribute( 'url' );
	// Don't render a link if there is no URL set.
	if ( ! $url ) {
		return '';
	}
	// Don't render a link if there is no URL set.
	/**
	 * Prepend emails with `mailto:` if not set.
	 * The `is_email` returns false for emails with schema.
	 */
	if ( is_email( $url ) ) {
		$url = 'mailto:' . $url;
	}
	/**
	 * Prepend URL with https:// if it doesn't appear to contain a scheme
	 * and it's not a relative link starting with //.
	 */
	if ( ! wp_parse_url( $url, PHP_URL_SCHEME ) && ! str_starts_with( $url, '//' ) ) {
		$url = 'https://' . $url;
	}
}

// Don't render a link if there is no URL set.
if ( ! ( $url = esc_attr( sanitize_url( wp_strip_all_tags( $url ) ) ) ) ) {
	return '';
}

$rel_target_attributes = '';
if ( $open_in_new_tab ) {
	$rel_target_attributes = 'rel="noopener nofollow" target="_blank"';
}

$icon = $this->attribute( 'customIconShortcode' ) ?: fndry_get_social_link_icons( $service );

$rootClasses = $this->rootClasses( [
	$this->bemMod( $service ),
	$this->renderResponsiveAttributes( [ 'spacing' => 'padding' ], false ),
], false );
$linkClass   = $this->bemSub( 'link' );
$labelClass  = $this->bemSub( 'label' ) . ' visually-hidden';
$border = '';
$borderStyles = $this->doBorderStyles( $this->getContext( 'border' ) );
$hoverBorderVars = $this->doBorderHoverStyles( $this->getContext( 'border' ), '--fndry-social-link-border-color-hover-' );

if ( $borderStyles || $hoverBorderVars ) {
	$styles = [];

	if ( $borderStyles ) {
		$styles[] = $borderStyles;
	}
	if ( $hoverBorderVars ) {
		$styles[] = $hoverBorderVars;
	}

	$border = " style='" . implode( ';', $styles ) . "'";
}

$label = wp_strip_all_tags( $this->attribute( 'label' ) ?: fndry_get_social_link_name( $service ), true );

$link =
	"<li class='$rootClasses'>
		<a href='$url' $rel_target_attributes class='$linkClass'$border>
			$icon
			<span class='$labelClass'>
				$label
			</span>
		</a>
	</li>";

// $link is sanitized above in parts.
echo $link; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped