<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly
$svgCls = $this->bemSub( 'ctrl-icon' )
?>
<div <?php
fndry_atts( [
	'class'            => [
		$this->rootClasses( [], false ),
		$this->bemMod( 'auto-height', $this->getAttribute( 'slideAutoHeight' ) ),
	],
	'id'               => $this->attribute( 'fndryBlockId' ),
	'data-fndry-js'    => 'slider',
	// base64 because slideCount is an object.
	'data-slide-count' => base64_encode( wp_json_encode( $this->getAttribute( 'slideCount' ) ) ),
	'data-gap'         => $this->getAttribute( 'gap' ),
	'data-slide-by'    => $this->getAttribute( 'slideBy' ),
	'data-auto-height' => $this->getAttribute( 'slideAutoHeight' ),
	'data-slider-type' => $this->getAttribute( 'sliderType' ) ?: 'carousel',
	'data-rewind'      => $this->getAttribute( 'rewind' ),
	'data-bound'       => $this->getAttribute( 'bound' ),
] ) ?>>
	<div data-fndry-js="slider-track" class="<?php
	echo esc_attr( $this->bemSub( 'track' ) ) ?>" data-glide-el="track">
		<ul class="<?php
		echo esc_attr( $this->bemSub( 'slides' ) ) ?>">
			<?php
			$this->renderInnerBlocks();
			?>
		</ul>
		<div class="<?php
		echo esc_attr( $this->bemSub( 'nav' ) ) ?>">
			<nav data-fndry-js="slider-controls" class="<?php
			echo esc_attr( $this->bemSub( 'controls' ) ) ?>"
			     data-glide-el="controls">
				<button
					class="<?php
					echo esc_attr( $this->bemSub( 'ctrl' ) ) ?> <?php
					echo esc_attr( $this->bemSub( 'ctrl-prev' ) ) ?>"
					data-glide-dir="&lt;">
					<?php
					if ( $this->getAttribute( 'slideCustomPrev' ) ) {
						echo fndry_strip_tags( $this->getAttribute( 'slideCustomPrev' ) );
					} else {
						?>
						<svg class='<?php
						echo esc_attr( $svgCls ) ?>' viewBox='0 0 448 512'>
							<path
								d='M447.1 256C447.1 273.7 433.7 288 416 288H109.3l105.4 105.4c12.5 12.5 12.5 32.75 0 45.25C208.4 444.9 200.2 448 192 448s-16.38-3.125-22.62-9.375l-160-160c-12.5-12.5-12.5-32.75 0-45.25l160-160c12.5-12.5 32.75-12.5 45.25 0s12.5 32.75 0 45.25L109.3 224H416C433.7 224 447.1 238.3 447.1 256z' />
						</svg>
						<?php
					} ?>
				</button>
				<button
					class="<?php
					echo esc_attr( $this->bemSub( 'ctrl' ) ) ?> <?php
					echo esc_attr( $this->bemSub( 'ctrl-next' ) ) ?>"
					data-glide-dir="&gt;">
					<?php

					if ( $this->getAttribute( 'slideCustomNext' ) ) {
						echo fndry_strip_tags( $this->getAttribute( 'slideCustomNext' ) );
					} else {
						?>
						<svg class='<?php
						echo esc_attr( $svgCls ) ?>' viewBox='0 0 448 512'>
							<path
								d='M438.6 278.6l-160 160C272.4 444.9 264.2 448 256 448s-16.38-3.125-22.62-9.375c-12.5-12.5-12.5-32.75 0-45.25L338.8 288H32C14.33 288 .0016 273.7 .0016 256S14.33 224 32 224h306.8l-105.4-105.4c-12.5-12.5-12.5-32.75 0-45.25s32.75-12.5 45.25 0l160 160C451.1 245.9 451.1 266.1 438.6 278.6z' />
						</svg>
						<?php
					} ?>
				</button>
			</nav>
			<?php
			if ( $this->getAttribute( 'slidePills' ) ) : ?>
				<nav data-fndry-js="slider-pills"
				     class="<?php
				     echo esc_attr( $this->bemSub( 'pills' ) ) ?>">
					<?php
					$innerBlocks = $this->innerBlocks;
					$pillCls     = $this->bemSub( 'pill' );
					$pillCount   = 0;
					if ( $innerBlocks ) {
						foreach ( $innerBlocks as $inner ) {
							$mod = $pillCount === 0 ? " $pillCls--active" : '';
							// tinyslider nav controls seems to only work with d:none and aria-hidden.
							echo wp_kses_post( "<button data-fndry-js='slider-pill' class='$pillCls$mod'></button>" );
							$pillCount ++;
						}
					}
					?>
				</nav>
			<?php
			endif; ?>
		</div>
	</div>
</div>
