<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

$heading     = fndry_strip_tags( $this->getAttribute( 'heading' ) );
$subheading  = fndry_strip_tags( $this->getAttribute( 'subheading' ) );
$imgZoom     = $this->context( 'fndry/imgZoom' );
$img_classes = [ $this->bemSub( 'img' ) ];

if ( $imgZoom ) {
	$img_classes[] = $this->bemSub( 'img-zoom' );
}

$get_image = wp_get_attachment_image(
	$this->attribute( "imageId" ),
	'full',
	false,
	[
		'class' => implode( ' ', $img_classes ),
		'style' => [
			'--slideout-img-zoom' => $this->context( "fndry/imgZoomScale" ),
		],
	]
);

$image_border_radius = $this->context( 'fndry/slideoutImageBorderRadius' );

$toggleIsText = $this->context( 'fndry/toggleIsText' );
$toggleIcon   = $this->context( 'fndry/toggleIcon' );
$toggleStyle  = $this->context( 'fndry/slideoutToggleStyle', true );

$headingLevel = $this->getContext( 'fndry/slideoutHeadingLevel' ) ?: 3;
?>
<div class="<?php $this->rootClasses() ?>" data-fndry-js="slideout-block">
    <a <?php
	fndry_atts( [
		'data-fndry-js' => 'slideout-content',
		'href'          => '#' . $this->getAttribute( "fndryBlockId" ),
		'type'          => 'button',
		'class'         => [
			$this->bemSub( 'slideout-content' ),
		],
		'aria-expanded' => false,
		'aria-controls' => $this->getAttribute( "fndryBlockId" ),
	] ); ?>>
        <div
	        <?php
	        fndry_atts( [
		        'class'         => [
			        $this->bemSub( 'img-container' ),
		        ],
		        'style' => [
					'border-radius' => $image_border_radius
		        ]
	        ] ); ?>
        >
			<?php echo wp_kses_post( $get_image ) ?>
        </div>
        <div class="<?php echo esc_attr( $this->bemSub( 'content' ) ) ?>">
            <div <?php fndry_atts( [ 'class' => [ $this->bemSub( 'heading-wrap' ) ] ] ) ?>>
                <div <?php fndry_atts( [
					'class' => [
						$this->bemSub( 'heading-wrap-container' ),
						$this->renderResponsiveAttributes( [
							'fndry/headingDisplay' => 'display',
							'fndry/headingFlex'    => 'flex',
							'fndry/headingAlign'   => 'align',
							'fndry/headingJustify' => 'justify',
						], false ),
					],
					'style' => [
						'--slideout-heading-gap' => $this->context( 'fndry/headingGap' ),
					],
				] ) ?>>
					<?php fndry_string(
						$heading,
						"h{$headingLevel}",
						[
							'class' => [ $this->bemSub( 'heading' ), $this->context( 'fndry/slideoutHeaderStyle' ) ],
						]
					) ?>
					<?php fndry_string(
						$subheading,
						'h5',
						[
							'class' => [
								$this->bemSub( 'subheading' ),
								$this->context( 'fndry/slideoutSubheadingStyle', true ),
							],
						]
					) ?>
                </div>
				<?php if ( $toggleIsText ) { ?>
                    <span
                            class="fndry-slideout-toggle <?php echo $toggleStyle !== ''
								? 'fndry-btn ' . esc_attr( $this->context( 'fndry/slideoutToggleStyle',
									true ) )
								: esc_attr( $this->renderResponsiveAttributes( [ 'fndry/slideoutToggleSpacing' => 'padding' ],
									false ) ); ?>"
                            data-content-before="<?php echo esc_attr( $this->context( 'fndry/toggleText' ) ); ?>"
                            data-content-after="<?php echo esc_attr( $this->context( 'fndry/toggleTextAfter' ) ); ?>"
                    >
                    </span>
				<?php } else { ?>
					<?php if ( $toggleIcon === 'default' ) { ?>
                        <span class="fndry-slideout-toggle"></span>
					<?php } else { ?>
                        <svg class="fndry-slideout-toggle chevron" viewBox="0 0 448 512">
                            <path
                                    d="m443.5 162.6-7.1-7.1a12 12 0 0 0-17 0L224 351 28.5 155.5a12 12 0 0 0-17 0l-7.1 7.1a12 12 0 0 0 0 17l211 211.1a12 12 0 0 0 17 0l211-211.1a12 12 0 0 0 .1-17z"
                                    fill="currentColor" />
                        </svg>
					<?php }
				} ?>
            </div>
            <div <?php fndry_atts(
				[
					'class' => [
						$this->bemSub( 'excerpt-wrap' ),
						$this->renderResponsiveAttributes( [
							'fndry/excerptJustify' => 'justify',
						], false ),
					],
				] ) ?>>
				<?php fndry_string(
					$this->getAttribute( "excerpt" ),
					'p',
					[
						'class' => [ $this->bemSub( 'excerpt' ), $this->context( 'fndry/slideoutExcerptStyle', true ) ],
					]
				) ?>
            </div>
        </div>
    </a>
    <div id="<?php echo esc_attr( $this->attribute( "fndryBlockId" ) ) ?>"
         class="<?php echo esc_attr( $this->bemSub( 'slideout-hidden' ) ) ?> fndry-collapse--hidden"
         data-fndry-js="slideout-hidden">
        <div class="<?php echo esc_attr( $this->bemSub( 'content-hidden' ) ) ?>">
			<?php if ( ! $this->getContext( 'fndry/hideCloseButton' ) ) : ?>
                <button data-fndry-js="slideout-close-btn"
                        class="<?php echo esc_attr( $this->bemSub( 'close-btn' ) ) ?>"
                        aria-label="Close"
                        aria-controls="<?php echo esc_attr( $this->getAttribute( "fndryBlockId" ) ) ?>">
                </button>
			<?php endif; ?>
			<?php $this->renderInnerBlocks(); ?>
        </div>
    </div>
</div>
