<?php
$textColor         = $this->attribute( "textColor" );
$level             = $this->getAttribute( 'headingLevel' );
$heading           = $this->getAttribute( 'heading' );
$paddingBottom     = $this->attribute( 'paddingBottom' );
$searchTermStyle   = $this->attribute( 'searchTermStyle' );
$searchTermColor   = $this->attribute( "searchTermColor" );
$headingContent    = $heading ?: 'Search results for: ';
$searchTermContent = get_search_query();
$headingTag        = "h$level";

$headingAttributes = [
	'class' => $this->rootClasses( [], false ),
	'style' => [
		'padding-bottom' => $paddingBottom,
		'--color'        => $textColor,
	],
];

$spanAttributes = [
	'class' => [ $this->bemSub( 'search-term' ), $searchTermStyle ],
	'style' => [
		'--color' => $searchTermColor,
	],
];

$span = '<span ' . fndry_atts( $spanAttributes, false ) . '>' . $searchTermContent . '</span>';

fndry_string(
	$headingContent . $span,
	$headingTag,
	$headingAttributes
);