<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly
$block      = $this->getBlockData();
$query      = $this->getContext( 'wpQuery' );
$background = $this->renderBackground();
if ( ! $query || ! $query->have_posts() ) {
	return '';
}

if ( $this->usesFeaturedImage() ) {
	update_post_thumbnail_cache( $query );
}
$justify = $this->renderResponsiveAttributes( [ 'justify' ], false );
$align   = $this->renderResponsiveAttributes( [ 'align' ], false );

$useFeaturedImageAsBackground = $this->attribute( 'useFeaturedImageAsBackground' );

$postWidth = $this->renderResponsiveAttributes( [ 'postWidth' ], false );

$responsiveInner = $this->renderResponsiveAttributes( [
	'postPadding',
	'innerDisplay',
	'innerFlex',
	'innerAlign',
	'innerJustify',
], false );

$content = '';
?>
<ul <?php
fndry_atts(
	[
		'class' => [
			'fndry-row',
			'fndry-row--gutter' => $this->getAttribute( 'gutter' ),
			'fndry-post-loop',
			$justify,
			$align,
		],
		'style' => $this->attribute( 'useOverlay' ) ?
			[
				'--overlayColor'   => $this->attribute( 'overlayColor' ),
				'--overlayOpacity' => $this->attribute( 'overlayOpacity' ),
			]
			: [],
	] ) ?>>
	<?php
	while ( $query->have_posts() ) {
		$query->the_post();

		$postClasses = get_post_class( 'fndry-post' ) ?? []; ?>
		<li <?php
		fndry_atts(
			[
				'class' => [
					$this->rootClasses( [], false ),
					'fndry-col',
					$postWidth,
					'fndry-post--sticky' => is_sticky(),
					is_array( $postClasses ) ? join( ' ', $postClasses ) : null,
				],
				'style' => [
					'--boxShadow' => $this->attribute( 'boxShadow' ),
				],
			]
		) ?>>
			<div <?php
			fndry_atts(
				[
					'style' => [
						...( $useFeaturedImageAsBackground && get_the_post_thumbnail_url() ? [ '--postLoopBg:url(' . get_the_post_thumbnail_url() . ')' ] : $background ),
						$this->doBorderStyles( $this->attribute( 'border' ) ),
						'border-radius' => $this->attribute( 'borderRadius' ),
					],
					'class' => [
						'fndry-post__inner',
						$useFeaturedImageAsBackground ? 'fndry-post__inner--has-bg' : 'fndry-responsive-bg',
						$responsiveInner,
					],
				]
			) ?>>
				<?php
				$this->renderInnerBlocks( [
					'postType' => get_post_type(),
					'postId'   => get_the_ID(),
					'isPost'   => true,
				] );
				?>
			</div>
		</li>
		<?php
	}
	wp_reset_postdata();
	?>
</ul>
