<?php

namespace ForgeSmith\Blocks;
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
use ForgeSmith\FoundryBlock;

class QueryPostTemplate extends FoundryBlock {
	public $bemClass = 'fndry-post';

	public function __construct( $attributes, $content = '', $wp_block = null ) {
		$parent = parent::__construct( $attributes, $content, $wp_block );

		$this->innerBlocks = array_map( [ $this, 'stripIds' ], $this->innerBlocks );

		return $parent;
	}

	//

	public function usesFeaturedImage( $innerBlocks = null ) {
		if ( $this->attribute( 'useFeaturedImageAsBackground' ) ) {
			return true;
		}
		foreach ( $innerBlocks ?: $this->innerBlocks as $block ) {
			if ( in_array( $block['blockName'], [ 'core/post-featured-image', 'foundry/post-featured-image' ] ) ) {
				return true;
			}
			if (
				'core/cover' === $block['blockName'] &&
				! empty( $block['attrs']['useFeaturedImage'] )
			) {
				return true;
			}
			if ( isset( $block['inner_blocks'] ) && ! empty( $block['inner_blocks'] ) && $this->usesFeaturedImage( $block['inner_blocks'] ) ) {
				return true;
			}
		}

		return false;
	}

	private function stripIds( $innerBlock ) {
		unset( $innerBlock['attrs']['fndryBlockId'] );

		if ( ! empty( $innerBlock['innerBlocks'] ) ) {
			$innerBlock['innerBlocks'] = array_map( [ $this, 'stripIds' ], $innerBlock['innerBlocks'] );
		}

		return $innerBlock;
	}
}