<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
$page_key = is_int( $this->getContext( 'queryId' ) ) ? 'query-' . $this->getContext( 'queryId' ) . '-page' : 'query-page';
$page     = empty( fndry_get_query_var( $page_key ) ) ? 1 : (int) fndry_get_query_var( $page_key );

$default_label    = 'Previous Page';
$label            = $this->getAttribute( 'label' ) ?: $default_label;
$pagination_arrow = $this->getContext( 'paginationArrow' ) === 'shortcode' ? $this->attribute(
	'iconShortcode'
) : get_query_pagination_arrow( $this, false );
if ( $pagination_arrow ) {
	$label = $pagination_arrow . $label;
}

$link        = esc_url( add_query_arg( $page_key, $page - 1 ) . "#" . $this->getContext( 'queryBlockId' ) );
$disabled    = $page === 1;
$href        = ! $disabled ? " href='$link'" : null;
$rootClasses = $this->rootClasses( [
	'fndry-btn',
	'fndry-pagination__nav',
	'fndry-pagination__nav--disabled' => $disabled,
	$this->context( 'fndry/buttonStyle' ),
], false );

$tag = $disabled ? 'div' : 'a';

fndry_string(
	$label,
	$tag,
	[
		'class' => $rootClasses,
		'href'  => $link,
	]
);