<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
$page_key = is_int( $this->getContext( 'queryId' ) ) ? 'query-' . $this->getContext( 'queryId' ) . '-page' : 'query-page';
$page     = empty( fndry_get_query_var( $page_key ) ) ? 1 : (int) fndry_get_query_var( $page_key );

$activePadding = $this->attribute( 'verticalPadding' ) . ' ' . $this->attribute( 'horizontalPadding' );

$cssVars = $this->generateCSSVars(
	[
		'--fndryPaginationActiveColor'   => $this->attribute( 'color' ),
		'--fndryPaginationActiveRadius'  => $this->attribute( 'borderRadius' ),
		'--fndryPaginationActivePadding' => $activePadding,
		'gap'                            => $this->attribute( 'gridGap' ),
	]
);

$wrapper_attributes = fndry_atts( [
	'class' => $this->rootClasses( [ $this->context( 'fndry/textStyle' ) ], false ),
	'style' => $cssVars,
], false);
$content            = '';

global $wp_query;

$block_query   = $this->getContext( 'wpQuery' );
$prev_wp_query = $wp_query;
$wp_query      = $block_query;
$total         = $wp_query->max_num_pages;
$paginate_args = [
	'base'      => '%_%',
	'format'    => "?$page_key=%#%#" . $this->getContext( 'queryBlockId' ),
	'current'   => max( 1, $page ),
	'total'     => $total,
	'prev_next' => false,
];
if ( 1 !== $page ) {
	/**
	 * `paginate_links` doesn't use the provided `format` when the page is `1`.
	 * This is great for the main query as it removes the extra query params
	 * making the URL shorter, but in the case of multiple custom queries is
	 * problematic. It results in returning an empty link which ends up with
	 * a link to the current page.
	 * A way to address this is to add a `fake` query arg with no value that
	 * is the same for all custom queries. This way the link is not empty and
	 * preserves all the other existent query args.
	 *
	 * @see https://developer.wordpress.org/reference/functions/paginate_links/
	 * The proper fix of this should be in core. Track Ticket:
	 * @see https://core.trac.wordpress.org/ticket/53868
	 * TODO: After two WP versions (starting from the WP version the core patch landed),
	 * we should remove this and call `paginate_links` with the proper new arg.
	 */
	$paginate_args['add_args'] = [ 'cst' => '' ];
}
// We still need to preserve `paged` query param if exists, as is used
// for Queries that inherit from global context.
$paged = empty( fndry_get_query_var('paged') ) ? null : (int) fndry_get_query_var('paged');
if ( $paged ) {
	$paginate_args['add_args'] = [ 'paged' => $paged ];
}
$content = paginate_links( $paginate_args );
wp_reset_postdata(); // Restore original Post Data.
$wp_query = $prev_wp_query;
fndry_string(
	$content,
	'div',
	$wrapper_attributes
);