<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
$page_key = is_int( $this->getContext( 'queryId' ) ) ? 'query-' . $this->getContext( 'queryId' ) . '-page' : 'query-page';
$page     = empty( fndry_get_query_var( $page_key ) ) ? 1 : (int) fndry_get_query_var( $page_key );

$default_label    = 'Next Page';
$label            = $this->getAttribute( 'label' ) ?: $default_label;
$pagination_arrow = $this->getContext( 'paginationArrow' ) === 'shortcode' ? $this->attribute(
	'iconShortcode'
) : get_query_pagination_arrow( $this, true );
if ( $pagination_arrow ) {
	$label .= $pagination_arrow;
}

$link  = null;
$query = null;

$query = $this->getContext( 'wpQuery' );
$link  = esc_url( add_query_arg( $page_key, $page + 1 ) ) . "#" . $this->getContext( 'queryBlockId' );
// figure we may as well keep this stuff sort of consistent and not just slap filters on *_posts_link_attributes
// i guess there'd be an advantage in that any addtl filters from the theme or w/e would be included, but if its all
// site-edit functionality and the archive page is a block page template... idk i don't really get it i guess.

$disabled    = ! ( (int) $query->max_num_pages && (int) $query->max_num_pages !== $page );
$rootClasses = $this->rootClasses( [
	'fndry-btn',
	'fndry-pagination__nav',
	'fndry-pagination__nav--disabled' => $disabled,
	$this->context( 'fndry/buttonStyle' ),
], false );

$tag = $disabled ? 'div' : 'a';

fndry_string(
	$label,
	$tag,
	[
		'class' => $rootClasses,
		'href'  => $link,
	]
);