<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
$queryId       = $this->getContext( 'queryId' );
$name          = "query-$queryId-search";
$queryVar      = fndry_get_query_var( $name );
$hasValue      = $queryVar ? " value=$queryVar" : '';
$iconShortcode = $this->attribute( 'iconShortcode' );
$iconColor     = $this->attribute( 'iconColor' );
?>
<div class="<?php
$this->rootClasses( [ 'fndry-form-ctrl' ] ) ?><?php echo esc_attr( $iconShortcode ? ' fndry-form-ctrl--custom-icon' : null ) ?>">
	<input class="<?php echo esc_attr( $this->bemSub( 'input' ) ) ?> fndry-js-placeholder fndry-form-ctrl__input"
	       id="<?php echo esc_attr( $name ) ?>"
	       name="<?php echo esc_attr( $name ) ?>" <?php echo esc_attr( $hasValue ) ?>>
	<label class="<?php echo esc_attr( $this->bemSub( 'label' ) ) ?> fndry-form-ctrl__label"
	       for="<?php echo esc_attr( $name ) ?>">
		<?php
		echo wp_kses_post( $this->getAttribute( 'searchLabel' ) ) ?>
	</label>
	<button class="fndry-form-ctrl__reset" type="button" data-target="<?php echo esc_attr( $name ) ?>">
		<span class="visually-hidden">
			Reset
		</span>
	</button>
	<?php
	if ( $iconShortcode ) : ?>
		<div <?php fndry_atts(
			[
				'class' => 'fndry-form-ctrl__icon',
				'style' => [
					'--color' => $iconColor,
				],
			]
		) ?>>
			<?php echo wp_kses_post( $iconShortcode ) ?>
		</div>
	<?php
	endif; ?>
</div>
