<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
$taxes = $this->attribute( 'taxonomies' );
if ( ! $taxes ) {
	return null;
}
$queryId       = $this->getContext( 'queryId' );
$postType      = $this->getContext( 'query' )['postType'];
$iconShortcode = $this->attribute( 'iconShortcode' );
$iconColor     = $this->attribute( 'iconColor' );
?>
<div <?php fndry_atts( [
	'class' => [
		$this->rootClasses( [], false ),
	],
] ) ?>>
	<?php
	foreach ( $taxes as $tax ) :
		if ( empty( $tax['slug'] ) || ! taxonomy_exists( $tax['slug'] ) ) {
			continue;
		}
		$defaultArgs = [
			'taxonomy'   => $tax['slug'],
			'parent'     => 0,
			'hide_empty' => true,
			'post_types' => $postType,
			'orderby'    => $tax['orderBy'] ?? 'name',
			'order'      => $tax['order'] ?? 'ASC',
		];

		$terms = get_terms( $defaultArgs );

		// todo - maybe switch to query_var instead?
		$taxSlug      = $tax['slug'];

		if ( $terms ) :
			$queryVar = "query-$queryId-$taxSlug";
			$selected = fndry_get_query_var( $queryVar )
			?>
			<div
				class="fndry-form-ctrl <?php echo esc_attr( $this->bemSub( 'tax' ) ) ?><?php echo esc_attr( $iconShortcode ? ' fndry-form-ctrl--custom-icon' : null ) ?>">
				<select id="<?php echo esc_attr( $queryVar ) ?>" name="<?php echo esc_attr( $queryVar ) ?>"
				        class="<?php echo esc_attr( $this->bemSub( 'select' ) ) ?> fndry-form-ctrl__select fndry-js-placeholder"
				        autocomplete="off">
					<option label="" value="" style="display: none"></option>
					<?php
					foreach ( $terms as $term ) :
						// phpcs:disable WordPress.Security.EscapeOutput.OutputNotEscaped
						echo fndry_recursive_select_children( $term, 0, $selected, $postType, $tax['displayCount'] ?? false );
						// phpcs:enable WordPress.Security.EscapeOutput.OutputNotEscaped
					endforeach ?>
				</select>
				<label class="<?php echo esc_attr( $this->bemSub( 'label' ) ) ?> fndry-form-ctrl__label"
				       for="<?php echo esc_attr( $queryVar ) ?>">
					<?php echo esc_attr( $tax['name'] ) ?>
				</label>
				<?php
				if ( ! $this->getAttribute( 'hideReset' ) ) : ?>
					<button class="fndry-form-ctrl__reset" type="button"
					        data-target="<?php echo esc_attr( $queryVar ) ?>">
						<span class="visually-hidden">
							Reset
						</span>
					</button>
				<?php
				endif;
				if ( $iconShortcode ) : ?>
					<div <?php fndry_atts(
						[
							'class' => 'fndry-form-ctrl__icon',
							'style' => [
								'--color' => $iconColor,
							],
						]
					) ?>>
						<?php echo wp_kses_post( $iconShortcode ) ?>
					</div>
				<?php
				endif; ?>
			</div>
		<?php
		endif;
	endforeach; ?>
</div>