<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly
$queryId  = $this->getContext( 'queryId' );
$postType = $this->getContext( 'query' )['postType'];

global $wp;
$formURL = $this->getAttribute( 'redirectToPage' ) ? $this->getAttribute( 'redirectToPage' ) : home_url( $wp->request . '#' . $this->getContext( 'queryBlockId' ) );
?>
<form <?php fndry_atts( [
	'id'            => $this->bemMod( $queryId ),
	'class'         => [
		$this->rootClasses( [], false ),
	],
	'method'        => 'GET',
	'action'        => $formURL,
	'data-fndry-js' => 'adv-filter',
	'style'         => [
		'--fndry-adv-filters-overlay-bg'                  => $this->attribute( 'backgroundColor' ),
		'--fndry-adv-filters-overlay-color'               => $this->attribute( 'textColor' ),
		'--fndry-adv-filters-overlay-btn-bg'              => $this->attribute( 'buttonBackground' ),
		'--fndry-adv-filters-overlay-btn-color'           => $this->attribute( 'buttonColor' ),
		'--fndry-adv-filters-overlay-input-bg'            => $this->attribute( 'inputBackgroundColor' ),
		'--fndry-adv-filters-overlay-input-box-shadow'    => $this->attribute( 'inputBoxShadow' ),
		'--fndry-adv-filters-overlay-input-border-radius' => $this->attribute( 'inputBorderRadius' ),
		'--fndry-form-ctrl-check-color'                   => $this->attribute( 'inputCheckColor' ),
		$this->doBorderStyles( $this->getAttribute( 'inputBorder' ), '--fndry-adv-filters-overlay-input-' ),
	],
] ) ?>>
	<div class="<?php echo esc_attr( $this->bemSub( 'container' ) ) ?>">
		<?php
		// renderButton is escaped.
		// phpcs:disable WordPress.Security.EscapeOutput.OutputNotEscaped
		echo $this->renderButton(
			'Show Filters',
			$this->getAttribute( 'showFiltersStyle' ),
			[
				'class'         => [
					$this->bemSub( 'btn-show' ),
				],
				'role'          => 'button',
				'type'          => 'button',
				'data-fndry-js' => 'adv-show-filters',
			]
		);
		// phpcs:enable WordPress.Security.EscapeOutput.OutputNotEscaped
		$this->renderInnerBlocks() ?>
	</div>
	<div class="<?php echo esc_attr( $this->bemSub( 'overlay' ) ) ?>" data-lenis-prevent="">
		<div class="<?php echo esc_attr( $this->bemSub( 'overlay-container' ) ) ?>" data-lenis-prevent="">
			<?php
			// phpcs:disable WordPress.Security.EscapeOutput.OutputNotEscaped
			echo $this->renderButton(
				'Hide Filters',
				$this->getAttribute( 'hideFiltersStyle' ),
				[
					'class'         => [
						$this->bemSub( 'btn-hide' ),
					],
					'role'          => 'button',
					'type'          => 'button',
					'data-fndry-js' => 'adv-hide-filters',
				]
			);
			// phpcs:enable WordPress.Security.EscapeOutput.OutputNotEscaped
			?>
			<div class="<?php echo esc_attr( $this->bemSub( 'fieldset' ) ) ?>">
				<?php
				foreach ( $this->getAttribute( 'taxonomies' ) as $tax ) {
					if ( ! taxonomy_exists( $tax['slug'] ) ) {
						continue;
					}

					// init tax "schema"
					$tax   = array_merge( [
						'slug'         => null,
						'name'         => null,
						'inputType'    => 'dropdown',
						'hierarchical' => null,
						'collapsible'  => null,
						'orderby'      => null,
						'order'        => null,
						'displayCount' => null,
						'placeholder'  => null,
					], $tax );
					$taxOb = get_taxonomy( $tax['slug'] );
					$label = $tax['placeholder'] ?? $taxOb?->label;

					$queryVar = "query-" . $this->getContext( 'queryId' ) . "-{$tax['slug']}";
					$selected = ! ! fndry_get_query_var( $queryVar );

					$hierarchical = $tax['hierarchical'];

					$args = [
						'taxonomy' => $tax['slug'],
						'orderby'  => 'name',
						'order'    => 'ASC',
					];

					if ( $hierarchical ) {
						// set up initial results
						$args = array_merge( $args, [ 'parent' => 0 ] );
					}

					// this will not return empty terms
					$terms = $this->getAttribute( 'showUnrelatedTerms' ) ? get_terms( $args ) : $this->getRelatedTerms( $args );

					if ( empty( $terms ) ) {
						continue;
					}

					?>
					<div class="<?php echo esc_attr( $this->bemSub( 'tax' ) ) ?>">
						<label <?php fndry_atts( [
								'class' => [
									$this->bemSub( 'label-lg' ),
									$this->attribute( 'inputLabelStyle' ),
								],
								'for'   => $queryVar,
							]
						) ?>>
							<?php echo wp_kses_post( $label ) ?>
						</label>
						<?php
						if ( $tax['inputType'] === 'dropdown' ) {
							?>
							<div class="fndry-form-ctrl">
								<select id="<?php echo esc_attr( $queryVar ) ?>"
								        name="<?php echo esc_attr( $queryVar ) ?>"
								        class="<?php echo esc_attr( $this->bemSub( 'select' ) ) ?> fndry-form-ctrl__select"
								        autocomplete="off">
									<option label="" value=""><?php echo esc_attr( $tax['placeholder'] ) ?></option>
									<?php
									foreach ( $terms as $term ) :
										// phpcs:disable WordPress.Security.EscapeOutput.OutputNotEscaped
										echo fndry_recursive_select_children( $term,
											0,
											$selected,
											$postType,
											$tax['displayCount'] );
										// phpcs:enable WordPress.Security.EscapeOutput.OutputNotEscaped
									endforeach ?>
								</select>
							</div>
							<?php
						} else {
							// for radio options, provide an "all" (i.e. empty) option because you can't deselect radios by default.
							if ( $tax['inputType'] === 'radio' ) { ?>
								<div class="fndry-form-ctrl-group">
									<label class="fndry-form-ctrl-box" for="<?php echo esc_attr( $queryVar ) ?>">
										<input type="radio"
										       class="fndry-form-ctrl-box__input"
										       name="<?php echo esc_attr( $queryVar ) ?>"
										       id="<?php echo esc_attr( $queryVar ) ?>"
											<?php echo fndry_get_query_var( $queryVar ) ? '' : 'checked' ?>
											   value="">
										All <?php echo esc_attr( $label ) ?>
										<span class="fndry-form-ctrl-box__radio">
											<span class="fndry-form-ctrl-box__radio-mark"></span>
										</span>
									</label>
								</div>
								<?php
							}
							// TODO - borders. Javascript.
							// phpcs:disable WordPress.Security.EscapeOutput.OutputNotEscaped

							foreach ( $terms as $term ) :
								echo fndry_recursive_input_group(
									$term,
									$queryVar,
									$selected,
									$postType,
									! ! $tax['displayCount'],
									! ! $tax['hierarchical'],
									$tax['inputType'],
									! ! $tax['collapsible']
								);
							endforeach;
							// phpcs:enable WordPress.Security.EscapeOutput.OutputNotEscaped

						} ?>
					</div>
					<?php
				} ?>
			</div>
			<?php
			// phpcs:disable WordPress.Security.EscapeOutput.OutputNotEscaped
			echo $this->renderButton(
				'Apply Filters',
				$this->getAttribute( 'applyFiltersStyle' ),
				[
					'class'         => [
						$this->bemSub( 'btn-apply' ),
					],
					'data-fndry-js' => 'adv-apply-filters',
				]
			);

			echo $this->renderButton(
				'Reset Filters',
				$this->getAttribute( 'resetFiltersStyle' ),
				[
					'class' => [
						$this->bemSub( 'btn-reset' ),
					],
					'href'  => home_url( $wp->request . '#' . $this->getContext( 'queryBlockId' ) ),
				],
				'a'
			);
			// phpcs:enable WordPress.Security.EscapeOutput.OutputNotEscaped

			?>
		</div>
	</div>
</form>