<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
$post_ID   = $this->getContext( 'postId' ) ?? get_the_ID();
$textColor = $this->attribute( "color" ) ?: $this->context( 'fndry/color' );
$title     = get_the_title( $post_ID );
$link      = $this->attribute('link') ?: get_the_permalink( $post_ID );

// isPost is explicitly provided by QueryPostTemplate to override scenarios where a query loop is used on an archive page
// this way we can use this whereever i guess
if ( ( is_archive() || is_tax() ) && ! $this->getContext( 'isPost' ) ) {
	$title = get_queried_object()->name;
	global $wp;
	$link = home_url( $wp->request );
}
if ( ! $title ) {
	return '';
}
$level    = $this->getAttribute( 'level' );
$tag_name = $level ? "h$level" : 'h2';

$link_wrapper_attributes = get_block_wrapper_attributes(
	[
		'class' => $this->bemSub( 'link' ),
	] );

if ( $this->getAttribute( 'isLink' ) ) {
	$title = sprintf( '<a href="%1$s" target="%2$s" rel="%3$s" %4$s>%5$s</a>',
		$link,
		esc_attr( $this->getAttribute( 'linkTarget' ) ),
		esc_attr( $this->getAttribute( 'rel' ) ),
		$link_wrapper_attributes,
		wp_kses_post( $title ) );
}
$align = $this->getAttribute( 'textAlign' ) ? 'has-text-align-' . $this->getAttribute( 'textAlign' ) : null;

fndry_string(
	$title,
	$tag_name,
	[
		'class' => $this->rootClasses( [ $align ], false ),
		'style' => [
			'color'         => $textColor,
			'margin-bottom' => $this->getAttribute( 'marginBottom' ),
		],
	],
);