<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
$taxes         = $this->getAttribute( 'taxonomies' );
$labelPosition = $this->getAttribute( 'labelPosition' );
$labelColon    = $this->getAttribute( 'addLabelColon' ) ? ":" : null;
$linkTarget    = $this->getAttribute( 'linkTarget' );
$linkRel       = $this->getAttribute( 'rel' );
$isLink        = $this->getAttribute( 'isLink' );

$labelStyle = $this->attribute( 'labelStyle' );
$termStyle = $this->attribute( 'termStyle' );

$tag_name = $isLink ? 'a' : 'div';
$responsiveBlockProps = $this->renderResponsiveAttributes( ['display', 'flex', 'justify', 'align'], false );

if ( empty( $taxes ) ) {
	return null;
}

$buttonStyle = $this->attribute( 'buttonStyle' );
$queryId     = $this->getContext( 'queryId' );
$postType    = $this->getContext( 'postType' );

?>
<div <?php fndry_atts(
	[
		'class' => $this->rootClasses( [], false ),
		'style' => [
			'--fndryGridGap' => $this->getAttribute( 'gridGap' ),
			'--separator'    => $this->getAttribute( 'separator' ) ? '"' . $this->getAttribute( 'separator' ) . '"' : false,
		],
	]
); ?>>
	<?php
	foreach ( $taxes as $tax ) :

		if ( ! taxonomy_exists( $tax['slug'] ) ) {
			continue;
		}

		$defaultArgs = [
			'taxonomy'   => $tax['slug'],
			'parent'     => 0,
			'hide_empty' => true,
			'post_types' => $postType,
			'exclude'    => [],
		];

		$terms = get_the_terms( get_the_ID(), $tax['slug'] );

		$taxSlug = $tax['slug'];

		if ( $terms ) :
			?>
			<div <?php fndry_atts( [
				'class' => [
					$this->bemSub( 'tax' ),
					'fndry-grid',
					'fndry-post-tax--' . $taxSlug,
					$responsiveBlockProps,
				],
				'style' => [
					'--color' => $this->attribute( 'termColor' ),
				],
			] ); ?>>
				<?php
				if ( $this->attribute( 'showTaxLabel' ) && isset( $tax['name'] ) ) : ?>
					<span <?php fndry_atts(
						[
							'class' => [
								$this->bemSub( 'label' ),
								$labelStyle,
								$this->bemSub( 'label' ) . "--$labelPosition" => $labelPosition,
							],
							'style' => [
								'--color' => $this->attribute( 'labelColor' ),
							],
						]
					) ?>>
						<?php echo wp_kses_post( "{$tax['name']}{$labelColon}" ) ?>
					</span>
				<?php
				endif; ?>
				<?php
				$queryVar = "query-$queryId-$taxSlug";
				$selected = fndry_get_query_var( $queryVar );

				foreach ( $terms as $term ) :
					$linkAtts = fndry_atts(
						array_merge(
							[
								'class' => [
									'fndry-btn' => $isLink,
									$isLink ? $buttonStyle : $termStyle,
									$this->bemSub( 'link' ),
									$this->bemSub( 'link' ) . '--' . $term->slug,
								],
							],
							$this->getAttribute( 'isLink' ) ? [
								'href'   => get_term_link( $term->term_id ),
								'target' => esc_attr( $linkTarget ),
								'rel'    => esc_attr( $linkRel ),
							] : []
						),
						false
					);

					?>
					<div class="<?php echo esc_attr( $this->bemSub( 'term' ) ) ?>">
						<?php
						echo wp_kses_post( "<$tag_name $linkAtts>" . $term->name . "</$tag_name>" ); ?>
					</div>
				<?php
				endforeach; ?>
			</div>
		<?php
		endif;
	endforeach; ?>
</div>