<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
if ( ! is_singular() ) {
	return '';
}

// Get the navigation type to show the proper link. Available options are `next|previous`.
$navigation_type = $this->attribute( 'type' ) ?: 'next';
// Allow only `next` and `previous` in `$navigation_type`.
if ( ! in_array( $navigation_type, [ 'next', 'previous' ], true ) ) {
	return '';
}
$classes = "post-navigation-link-$navigation_type";
$align   = $this->attribute( 'textAlign' );
if ( $this->attribute( 'textAlign' ) ) {
	$classes .= " has-text-align-$align";
}
$wrapper_attributes = fndry_atts( [
	'class' => [
		$this->rootClasses( [], false ),
		$classes,
	],
], false);
// Set default values.
$format = '%link';
$link   = 'next' === $navigation_type ? 'Next' : 'Previous';
$label  = '';

// If a custom label is provided, make this a link.
// `$label` is used to prepend the provided label, if we want to show the page title as well.
$label = $this->attribute( 'label' );
if ( $label ) {
	$link = $label;
}

$showTitle = $this->attribute( 'showTitle' );
$linkLabel = $this->attribute( 'linkLabel' );
// If we want to also show the page title, make the page title a link and prepend the label.
if ( $showTitle ) {
	/*
	 * If the label link option is not enabled but there is a custom label,
	 * display the custom label as text before the linked title.
	 */
	if ( ! $linkLabel ) {
		if ( $label ) {
			$format = '<span class="post-navigation-link__label">' . wp_kses_post( $label ) . '</span> %link';
		}
		$link = '%title';
	} else {
		// If the label link option is enabled and there is a custom label, display it before the title.
		if ( $label ) {
			$link = '<span class="post-navigation-link__label">' . wp_kses_post( $label ) . '</span> <span class="post-navigation-link__title">%title</title>';
		} else {
			/*
			 * If the label link option is enabled and there is no custom label,
			 * add a colon between the label and the post title.
			 */
			$label = 'next' === $navigation_type ? 'Next:' : 'Previous:';
			$link  = sprintf(
				'<span class="post-navigation-link__label">%1$s</span> <span class="post-navigation-link__title">%2$s</span>',
				wp_kses_post( $label ),
				'%title'
			);
		}
	}
}

// The dynamic portion of the function name, `$navigation_type`,
// refers to the type of adjacency, 'next' or 'previous'.
$get_link_function = "get_{$navigation_type}_post_link";
$content           = $get_link_function( $format, $link );

echo wp_kses_post("<div $wrapper_attributes>$content</div>");