<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! has_post_thumbnail( get_the_ID() ) ) {
	return null;
}

$tagName   = 'div';
$fit       = $this->attribute( "imageFit" );
$imageAlt  = $this->attribute( "imageAlt" );
$height    = $this->attribute( "height" );
$heightAll = $height['all'] ?? 'auto';
$heightMd  = $height['md'] ?? 'auto';
$heightSm  = $height['sm'] ?? 'auto';
$width     = $this->attribute( "width" );
$imagePosX = $this->attribute( "focalPoint" )['x'] * 100 . '%';
$imagePosY = $this->attribute( "focalPoint" )['y'] * 100 . '%';
$filters   = $this->doCSSFilters( $this->getAttribute( "filters" ) );
$size_slug = $this->attribute( 'imageSize' ) ?: $this->attribute( 'sizeSlug' ) ?: 'post-thumbnail';

$wrapper_attributes = [
	'class' => [ $this->rootClasses( [], false ) ],
	'style' => [
		'--imageWidth'     => $width,
		'--img-height-all' => $heightAll,
		'--img-height-md'  => $heightMd,
		'--img-height-sm'  => $heightSm,
	],
];

$thumbnail_id      = get_post_thumbnail_id( get_the_ID() );
$media_library_alt = get_post_meta( $thumbnail_id, '_wp_attachment_image_alt', true );

$imageAlt = $imageAlt ?: $media_library_alt ?: get_the_post_thumbnail_caption();
$showImageAlt = $this->getAttribute( 'showImageAlt' );
$captionProps = $this->renderResponsiveAttributes( [ 'paddingCaption', 'marginCaption' ], false );
$captionColor = $this->attribute( "captionColor" );
$captionStyle = $this->attribute( 'captionStyle' );

if ( $this->attribute( 'isLink' ) ) {
	$tagName = 'a';
	$wrapper_attributes['href']    = $this->attribute('link') ?: get_the_permalink();
	$wrapper_attributes['class'][] = $this->bemMod( 'link' );
}

$width  = $this->getAttribute( 'width' );
$height = $this->getAttribute( 'height.all' );
// only use width & height array if the user has provided specific values for each.
$canUseWidthHeight = ! ! $width && ! ! $height && str_contains( $width, 'px' ) && str_contains( $height, 'px' );

$imageSize = $canUseWidthHeight ? [
	(int) $width,
	(int) $height,
] : $size_slug;

$image_html = get_the_post_thumbnail(
	get_the_ID(),
	$imageSize,
	[
		'alt'         => $imageAlt,
		'class'       => $this->bemSub( 'img' ),
		'aria-hidden' => ! $imageAlt ? 'true' : false,
		'data-lity'   => $this->getAttribute( 'lity' ),
		'style'       => array_merge( [
			'border-radius' => $this->attribute( 'borderRadius' ),
			'--objectFit'   => $fit,
			'--imagePosX'   => $imagePosX,
			'--imagePosY'   => $imagePosY,
		], $filters ),
	]
);

$caption_html = '';
if ( $showImageAlt && ! empty( $imageAlt ) ) {
	$caption_attributes = [
		'id'    => [ 'img-' . $thumbnail_id ],
		'class' => [
			$this->bemSub( 'caption' ),
			$captionProps,
			$captionStyle,
		],
		'style' => [
			$this->applyPositioning('captionPositionProps'),
			'--color' => $captionColor,
		],
	];

	$caption_html = sprintf(
		'<figcaption %s>%s</figcaption>',
		fndry_atts( $caption_attributes, false ),
		esc_html( $imageAlt )
	);
}

fndry_string(
	$image_html . $caption_html,
	$tagName,
	$wrapper_attributes
);
