<?php

namespace ForgeSmith\Blocks;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly
use ForgeSmith\FoundryBlock;

class PostFeaturedImage extends FoundryBlock {

	public          $bemClass     = 'fndry-post-featured-image';
	protected array $deprecations = [
		'height' => [ self::class, 'handleHeightDep' ],
	];

	protected static function handleHeightDep( $value ): array {
		if ( is_string( $value ) ) {
			return [
				'all' => $value,
			];
		}

		return $value;
	}
}