<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
$excerpt = get_the_excerpt();
$excerpt_length = $this->getAttribute( 'excerptLength' );

if ( $excerpt_length && is_numeric( $excerpt_length ) ) {
	$excerpt = wp_trim_words( $excerpt, $excerpt_length );
}

$more_text = $this->getAttribute( 'moreText' );

if ( empty( $excerpt ) ) {
	return null;
}

$more_text = $more_text ?
	fndry_string( $more_text, 'a',
		[
			'href'  => esc_url( get_the_permalink() ),
			'class' => $this->bemSub( 'more-link' ),
		], false )
	: '';

$filter_excerpt_more = function ( $more ) use ( $more_text ) {
	return empty( $more_text ) ? $more : '';
};
/**
 * Some themes might use `excerpt_more` filter to handle the
 * `more` link displayed after a trimmed excerpt. Since the
 * block has a `more text` attribute we have to check and
 * override if needed the return value from this filter.
 * So if the block's attribute is not empty override the
 * `excerpt_more` filter and return nothing. This will
 * result in showing only one `read more` link at a time.
 */
add_filter( 'excerpt_more', $filter_excerpt_more );
$classes = '';
// TODO - redo this block lol

$show_more_on_new_line = $this->getAttribute( 'showMoreOnNewLine' ) && ! empty( $more_text );

if ( ! $show_more_on_new_line ) {
	$excerpt = $excerpt . " " . $more_text;
}

$textStyle = $this->attribute( 'textStyle' );

$content = fndry_string( $excerpt, 'p', [
	'class' => [
		$this->bemSub( 'excerpt' ),
		$textStyle,
	],
	'style' => [
		'color'         => $this->attribute( 'color' ),
		'margin-bottom' => $this->getAttribute( 'marginBottom' ),
	],
], false );

if ( $show_more_on_new_line ) {
	$content .= fndry_string( $more_text, 'p', [
		'class' => [
			$this->bemSub( 'more-text' ),
			$textStyle,
		],
		'style' => [
			'color'         => $this->attribute( 'color' ),
			'margin-bottom' => $this->getAttribute( 'marginBottom' ),
		],
	], false );
}

remove_filter( 'excerpt_more', $filter_excerpt_more );
fndry_string( $content, 'div', [
	'class' => $this->rootClasses( [], false ),
] );