<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
$textAlign = $this->getAttribute( "textAlign" );
$textColor = $this->attribute( "textColor" );
$style     = $this->attribute( 'authorStyle' );
$isLink    = $this->attribute( 'nameIsLink' );
$heading   = $this->getAttribute( 'heading' );
$author_id = get_post_field( 'post_author', get_the_ID() );
if ( empty( $author_id ) ) {
	return '';
}
$class = is_array( $textAlign ) ? $this->renderResponsiveProps( 'textAlign' ) : $this->bemMod( $textAlign );

$author_name = get_the_author_meta( 'display_name', $author_id );

if ( $isLink ) {
	$author_url  = get_author_posts_url( $author_id );
	$author_name = '<a href="' . esc_url( $author_url ) . '">' . wp_kses_post( $author_name ) . '</a>';
}

fndry_string(
	$author_name,
	'div',
	[
		'class' => $this->rootClasses( [ $class ], false ),
		'style' => [
			'--color'       => $textColor,
			'margin-bottom' => $this->attribute( 'marginBottom' ),
		],
	]
);