<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

$radius     = $this->attribute( "borderRadius" );
$fit        = $this->attribute( "imageFit" );
$imageAlt   = $this->attribute( "imageAlt" );
$avatarSize = $this->attribute( "avatarSize" );
$isLink     = $this->attribute( 'avatarIsLink' );
$filters    = $this->doCSSFilters( $this->getAttribute( "filters" ) );
$author_id  = get_post_field( 'post_author', get_the_ID() );

if ( empty( $author_id ) ) {
	return '';
}

$avatar = ! empty( $this->attribute( 'avatarSize' ) ) ? get_avatar(
	$author_id,
	$this->attribute( 'avatarSize' )
) : null;

$avatar_src = get_avatar_url( $author_id, [ 'size' => $avatarSize ] );
$author_url = get_author_posts_url( $author_id );
?>
<div <?php fndry_atts( [
	'class' => [ $this->rootClasses( [ $this->renderResponsiveProps( 'padding' ) ], false ), ],
	'style' => $filters,
] ) ?>>
	<?php
	if ( $isLink ) : ?>
	<a href="<?php echo esc_url( $author_url ); ?>">
		<?php
		endif; ?>
		<img<?php fndry_atts( [
			'class' => [ $this->bemSub( 'img' ), false ],
			'src'   => $avatar_src,
			'style' => array_merge( [
				$this->doBorderStyles( $this->attribute( 'border' ) ),
				'border-radius' => $this->getAttribute( 'borderRadius' ),
				'--objectFit'   => $fit,
			], $filters ),
		] ) ?>>
		<?php
		if ( $isLink ) : ?>
	</a>
<?php
endif; ?>
</div>