<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
$authorStyle = $this->attribute( "authorStyle" ) ? " " . $this->attribute( "authorStyle" ) : "";
$bylineStyle = $this->attribute( "bylineStyle" ) ? " " . $this->attribute( "bylineStyle" ) : "";
$bioStyle    = $this->attribute( "bioStyle" ) ? " " . $this->attribute( "bioStyle" ) : "";
$showMore    = $this->attribute( "showMore" );

$hasBio    = $this->attribute( "showBio" ) === true ? "has-bio" : "";
$borderRad = $this->attribute( "borderRadius" ) ? "border-radius: " . $this->attribute( "borderRadius" ) : "";

$author_id = get_post_field( 'post_author' );
if ( empty( $author_id ) ) {
	return '';
}

$avatar = ! empty( $this->attribute( 'avatarSize' ) ) ? get_avatar(
	$author_id,
	$this->attribute( 'avatarSize' )
) : null;

$byline = $this->attribute( 'byline' ) ?: false;

?>
<div <?php fndry_atts( [
	'class' => $this->rootClasses( [
		$this->bemMod( $hasBio ),
		$this->bemMod( $this->attribute( "textAlign" ) ),
	], false ),
] ) ?>>
	<?php
	if ( $this->attribute( 'showAvatar' ) ) {
		fndry_string( $avatar, 'div', [
			'class' => [
				$this->bemSub( 'avatar' ),
			],
			'style' => [
				'border-radius' => $this->getAttribute( 'borderRadius' ),
			],
		] );
	} ?>
	<div class="<?php echo esc_attr($this->bemSub( 'content' )) ?>">
		<?php
		if ( $byline ) {
			fndry_string( wp_kses_post( $byline ), 'p', [ 'class' => [ $this->bemSub( 'byline' ), $bylineStyle ] ] );
		}
		fndry_string( get_the_author_meta( 'display_name', $author_id ),
			'p',
			[ 'class' => [ $this->bemSub( 'name' ), $authorStyle ] ] );

		if ( $this->attribute( 'showBio' ) )
			fndry_string( get_the_author_meta( 'user_description', $author_id ),
				'p',
				[ 'class' => [ $this->bemSub( 'bio' ), $bioStyle ] ] )
		?>
		<?php
		if ( $showMore === true ) {
			$this->renderInnerBlocks( [ "url" => get_author_posts_url( $author_id ) ] );
		} ?>
	</div>
</div>