<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly
// todo - why are we duplicating navlink code here? shouldn't the submenu just exist by itself?
$isActive = false;
$obj      = get_queried_object();
$savedID  = $this->attribute( 'postId' );
if ( is_a( $obj, 'WP_Term' ) ) {
	$isActive = $obj->term_id === $savedID;
} elseif ( is_a( $obj, 'WP_Post' ) ) {
	$isActive = $obj->ID === $savedID;
}

?>
<li class="fndry-nav__item fndry-nav__item--has-submenu" data-fndry-js="nav-item-has-submenu">
    <a <?php fndry_atts(
		[
			'class'           => [
				$this->getAttribute( 'className' ),
				'fndry-nav-link',
				$this->renderResponsiveAttributes( [ 'itemPadding' => 'padding' ], false ),
				$isActive ? ' fndry-nav-link--active' : null,
			],
			'href'            => $this->attribute( 'url' ),
			'title'           => $this->attribute( 'title' ),
			'target'          => $this->attribute( 'opensInNewTab' ) ? '_blank' : '',
			'rel'             => $this->attribute( 'rel' ),
			'data-navigation' => 'link',
		]
	) ?>>
		<?php echo wp_kses_post( $this->attribute( 'label' ) ) ?>
    </a>
    <button data-fndry-js="nav-submenu-toggle" class="fndry-nav__submenu-toggle" aria-expanded="false"
            aria-label="Toggle <?php echo esc_attr( wp_strip_all_tags( $this->getAttribute( 'label' ) ) ) ?> submenu">
    </button>
    <ul class="fndry-nav-submenu">
		<?php
		$this->renderInnerBlocks() ?>
    </ul>
</li>