<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
$isActive = false;
$obj      = get_queried_object();
$savedID  = $this->attribute( 'postId' );
if ( is_a( $obj, 'WP_Term' ) ) {
	$isActive = $obj->term_id === $savedID;
} elseif ( is_a( $obj, 'WP_Post' ) ) {
	$isActive = $obj->ID === $savedID;
}
?>
<li class="fndry-nav__item">
	<a <?php fndry_atts(
		[
			'href'   => $this->attribute( 'url' ),
			'title'  => $this->attribute( 'title' ),
			'target' => $this->attribute( 'opensInNewTab' ) ? '_blank' : '',
			'rel'    => $this->attribute( 'rel' ),
			'class'  => $this->rootClasses( [
				$this->renderResponsiveAttributes( [ 'itemPadding' => 'padding' ], false ),
				$this->bemMod( 'active', $isActive ),
			], false ),
		]
	); ?>>
		<?php echo wp_kses_post( $this->getAttribute( 'label' ) ) ?>
	</a>
</li>