<?php

use ForgeSmith\Foundry;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly
if ( ! $this->menu ) {
	return;
}
// css vars from our big objects.
// TODO - i want to move this to the construct but helper functions need to be trait-ized

$hasIcon = $this->attribute( 'hasIcon', true );

$styleObjs  = [
	'defaultStyle'        => $this->attribute( 'defaultStyle' ),
	'submenuStyle'        => $this->attribute( 'submenuStyle' ),
	'overlayStyle'        => $this->attribute( 'overlayStyle' ),
	'overlaySubmenuStyle' => $this->attribute( 'overlaySubmenuStyle' ),
];
$tmpStyles  = [];
$underlines = [];
$instance   = Foundry::instance();
foreach ( $styleObjs as $prefix => $style ) {
	$prefix    = str_replace( 'Style', '', $prefix );
	$varPrefix = "--fndry-nav-${prefix}";
	if ( is_array( $style ) ) {
		foreach ( $style as $prop => $val ) {
			if ( $val ) {
				$cssPrefix = "${varPrefix}-${prop}";
				if ( is_array( $val ) ) {
					foreach ( $val as $subProp => $subVal ) {
						if ( $subVal ) {
							if ( is_bool( $subVal ) ) {
								$underlines[] = $this->bemMod( "$prefix-$prop-$subProp" );
							} else {
								if ( is_string( $subVal ) && strpos( $subVal, '--' ) === false ) {
									$subVal = $instance->maybeGetSettingKey( $subVal );
								}
								$tmpStyles[] = "$cssPrefix-$subProp:$subVal;";
							}
						}
					}
				} else {
					if ( is_string( $val ) && strpos( $val, '--' ) === false ) {
						$val = $instance->maybeGetSettingKey( $val );
					}
					$tmpStyles[] = "$cssPrefix:$val;";
				}
			}
		}
	}
}

$cssVars = " " . implode( ' ', array_filter( $tmpStyles ) );

$navigationPosition = $this->attribute( 'navigationPosition', 'fixed' );
$navigationTop      = $this->attribute( 'navigationTop', '0' );
$navigationRight    = $this->attribute( 'navigationRight', '0' );
$navigationBottom   = $this->attribute( 'navigationBottom', '0' );
$navigationLeft     = $this->attribute( 'navigationLeft', '0' );
?>
<nav
	<?php fndry_atts( [
		'class'         => [
			$this->rootClasses( $underlines, false ),
			$this->bemMod( 'submenus-hover', ! $this->attribute( 'openSubmenusOnClick' ) ),
		],
		'data-fndry-js' => 'nav',
		'id'            => 'fndry-nav-' . $this->attribute( 'ref' ),
		'aria-label'    => $this->menu->post_title,
		'style'         => [
			$cssVars,
			'--fndry-nav-menu-toggle-color'     => $this->attribute( 'overlayMenuToggleIconColor' ),
			'--fndry-nav-bg'                    => $this->attribute( 'backgroundColor' ),
			'--fndry-nav-overlayBg'             => $this->attribute( 'overlayBackgroundColor' ),
			'--fndry-nav-submenuBg'             => $this->attribute( 'submenuBackgroundColor' ),
			'--fndry-nav-close-icon-color'      => $this->attribute( 'overlayCloseIconColor' ),
			'--responsive-container-offset-top' => $this->getAttribute( 'positionProps.top' ),
			'--responsive-container-z-index'    => $this->getAttribute( 'positionProps.zIndex' ),
			'--mobile-close-offset-top'         => $this->getAttribute( 'closeBtnPositionProps.top' ),
			'--mobile-close-offset-right'       => $this->getAttribute( 'closeBtnPositionProps.right' ),
		],
	] ); ?>
>
	<?php
	if ( $hasIcon ): ?>
        <button data-fndry-js="nav-toggle" class="<?php echo esc_attr( $this->bemSub( 'toggle' ) ) ?> nav-with-icon"
                aria-haspopup="true"
                aria-label="<?php echo 'Open Menu' ?>">
            <span class="<?php echo esc_attr( $this->bemSub( 'toggle-lines' ) ) ?>"></span>
        </button>
	<?php
	else: ?>
        <button data-fndry-js="nav-toggle" class="<?php echo esc_attr( $this->bemSub( 'toggle' ) ) ?> nav-no-icon"
                aria-haspopup="true"
                aria-label="<?php echo 'Open Menu' ?>">
			<?php echo 'Menu' ?>
        </button>
	<?php
	endif; ?>
    <div data-fndry-js="nav-responsive-container"
         class="<?php echo esc_attr( $this->bemSub( 'responsive-container' ) ) ?>"
         data-lenis-prevent="">
        <div class="<?php echo esc_attr( $this->bemSub( 'responsive-close' ) ) ?>" tabindex="-1">
            <div data-navigation="responsive-dialog"
                 class="<?php echo esc_attr( $this->bemSub( 'responsive-dialog' ) ) ?>"
                 aria-label="<?php echo 'Menu' ?>">
				<?php if ( ! $this->getAttribute( 'hideCloseBtn' ) ) : ?>
                    <button aria-label="<?php echo 'Close Menu' ?>"
                            data-fndry-js="nav-responsive-container-close"
                            class="<?php echo esc_attr( $this->bemSub( 'responsive-container-close' ) ) ?>"
                    >
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="24" height="24"
                             aria-hidden="true" focusable="false">
                            <path fill="currentColor"
                                  d="M13 11.8l6.1-6.3-1-1-6.1 6.2-6.1-6.2-1 1 6.1 6.3-6.5 6.7 1 1 6.5-6.6 6.5 6.6 1-1z"></path>
                        </svg>
                    </button>
				<?php endif; ?>
                <div class="<?php echo esc_attr( $this->bemSub( 'responsive-container-content' ) ) ?>"
                     id="<?php
				     echo esc_attr( $this->getAttribute( 'ref' ) ) ?>-content">
					<?php

					$innerBlocksHtml = '';
					$is_list_open    = false;

					$submenuBlocks = [
						'foundry/navigation-link',
						'core/home-link',
						'core/site-title',
						'core/site-logo',
						'foundry/navigation-submenu',
						'core/search',
						'foundry/nav-search',
					];

					$context = [
						'itemPadding' => $this->attribute( 'itemPadding' ),
					];

					foreach ( new WP_Block_List( $this->innerBlocks, $context ) as $innerBlock ) {
						if ( in_array( $innerBlock->name, $submenuBlocks ) && ! $is_list_open ) {
							$is_list_open    = true;
							$flex            = $this->renderResponsiveAttributes( [ 'flex', 'justify', 'align' ],
								false );
							$innerBlocksHtml .= "<ul class='fndry-nav__container $flex'>";
						}
						if ( ! in_array( $innerBlock->name, $submenuBlocks ) && $is_list_open ) {
							$is_list_open    = false;
							$innerBlocksHtml .= '</ul>';
						}
						if ( $innerBlock->name == 'foundry/nav-search' ) {
							$innerBlocksHtml .= '<li class="fndry-nav__item fndry-nav__item--has-search">' . $innerBlock->render() . '</li>';
						} elseif ( in_array( $innerBlock->name,
							[ 'core/site-title', 'core/search', 'core/site-logo' ] ) ) {
							$innerBlocksHtml .= '<li class="fndry-nav__item">' . $innerBlock->render() . '</li>';
						} else {
							$innerBlocksHtml .= $innerBlock->render();
						}
					}

					if ( $is_list_open ) {
						$innerBlocksHtml .= '</ul>';
					}

					echo $innerBlocksHtml;
					?>
                </div>
            </div>
        </div>
    </div>
</nav>
