<?php

namespace ForgeSmith\Blocks;
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
use ForgeSmith\FoundryBlock;

class Navigation extends FoundryBlock {
	public    $bemClass = 'fndry-nav';
	protected $menu;

	protected array $styles     = [];
	protected array $underlines = [];

	public function __construct( $attributes, $content = '', $wp_block = '' ) {
		$parent = parent::__construct( $attributes, $content, $wp_block );
		//
		$this->menu = get_post( $this->attribute( 'ref' ) );

		// abort if the ref doesn't match an existing post.
		if ( ! $this->menu ) {
			return $parent;
		}

		$parsedBlocks         = parse_blocks( $this->menu->post_content );
		$compactedInnerBlocks = block_core_navigation_filter_out_empty_blocks( $parsedBlocks );

		$this->innerBlocks = $compactedInnerBlocks;

		return $parent;
	}
}