<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
$name          = "s";
$queryVar      = fndry_get_query_var( $name );
$hasValue      = $queryVar ? " value='$queryVar'" : '';
$clickToReveal = $this->attribute( 'clickToReveal' );
$shouldToggle  = $clickToReveal !== 'off';
// clickToReveal === 'sm' --->
?>
<div <?php fndry_atts( [
	'class'         => [
		$this->rootClasses( [
			$this->bemMod( "reveal-$clickToReveal", $shouldToggle ),
			$this->bemMod( 'click-to-reveal', $shouldToggle ),
		], false ),
	],
	'data-fndry-js' => $shouldToggle ? "nav-click-to-reveal" : false,
] )
?>>
	<?php
	if ( $clickToReveal !== 'always' ) : ?>
		<form class="<?php echo esc_attr( $this->bemSub( 'form' ) ) ?> fndry-form-ctrl"
		      action="<?php echo esc_attr( get_home_url() ) ?>" method="get" role="search">
			<input
				<?php
				fndry_atts( [
					'class' => [
						$this->bemSub( 'input' ),
						'fndry-js-placeholder',
						'fndry-form-ctrl__input',
					],
					'id'    => $name,
					'name'  => $name,
					'value' => ! ! $queryVar ? $queryVar : false, // ensure empty strings don't count
				] ); ?> />
			<label class="<?php echo esc_attr( $this->bemSub( 'label' ) ) ?> fndry-form-ctrl__label"
			       for="<?php echo esc_attr( $name ) ?>">
				<?php
				echo wp_kses_post( $this->getAttribute( 'placeholder' ) ) ?>
			</label>
			<button class="fndry-form-ctrl__reset" type="button" data-target="<?php echo esc_attr( $name ) ?>">
				<span class="visually-hidden">
					Reset
				</span>
			</button>
			<button class="<?php echo esc_attr( $this->bemSub( 'submit' ) ) ?>" type="submit">
				<svg class="<?php echo esc_attr( $this->bemSub( 'submit-icon' ) ) ?>" aria-hidden="true" role="img"
				     xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512">
					<path fill="currentColor"
					      d="M416 208c0 45.9-14.9 88.3-40 122.7L502.6 457.4c12.5 12.5 12.5 32.8 0 45.3s-32.8 12.5-45.3 0L330.7 376c-34.4 25.2-76.8 40-122.7 40C93.1 416 0 322.9 0 208S93.1 0 208 0S416 93.1 416 208zM208 352c79.5 0 144-64.5 144-144s-64.5-144-144-144S64 128.5 64 208s64.5 144 144 144z"></path>
				</svg>
			</button>
		</form>
	<?php
	endif; ?>
	<?php
	if ( $shouldToggle ) : ?>
		<form data-fndry-js="nav-search-form-expand"
		      class="<?php echo esc_attr( $this->bemSub( 'form' ) ) ?> <?php echo esc_attr( $this->bemSub( 'form--expand' ) ) ?> fndry-form-ctrl"
		      action="<?php echo esc_attr( get_home_url() ) ?>" method="get" role="search">
			<input
				<?php
				fndry_atts( [
					'class' => [
						$this->bemSub( 'input' ),
						'fndry-js-placeholder',
						'fndry-form-ctrl__input',
					],
					'id'    => $name,
					'name'  => $name,
					'value' => ! ! $queryVar ? $queryVar : false, // ensure empty strings don't count
				] ); ?> />
			<label class="<?php echo esc_attr( $this->bemSub( 'label' ) ) ?> fndry-form-ctrl__label"
			       for="toggle-<?php echo esc_attr( $name ) ?>">
				<?php
				echo wp_kses_post( $this->getAttribute( 'placeholder' ) ) ?>
			</label>
			<button class="fndry-form-ctrl__reset" type="button" data-target="toggle-<?php echo esc_attr( $name ) ?>">
				<span class="visually-hidden">
					Reset
				</span>
			</button>
			<button class="<?php echo esc_attr( $this->bemSub( 'submit' ) ) ?>" type="submit">
				<svg class="<?php echo esc_attr( $this->bemSub( 'submit-icon' ) ) ?>" aria-hidden="true"
				     xmlns="http://www.w3.org/2000/svg"
				     viewBox="0 0 320 512">
					<path fill="currentColor"
					      d="M279 233c12 13 12 33 0 46L119 439a32 32 0 0 1-46-46l138-137L73 119a32 32 0 0 1 46-46l160 160z" />
				</svg>
			</button>
		</form>
		<button data-fndry-js="nav-search-toggle" class="<?php echo esc_attr( $this->bemSub( 'toggle' ) ) ?>">
			<span class="<?php echo esc_attr( $this->bemSub( 'toggle-icon' ) ) ?>">
				<svg class="<?php echo esc_attr( $this->bemSub( 'toggle-icon-open' ) ) ?>" aria-hidden="true" role="img"
				     xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512">
					<path fill="currentColor"
					      d="M416 208c0 45.9-14.9 88.3-40 122.7L502.6 457.4c12.5 12.5 12.5 32.8 0 45.3s-32.8 12.5-45.3 0L330.7 376c-34.4 25.2-76.8 40-122.7 40C93.1 416 0 322.9 0 208S93.1 0 208 0S416 93.1 416 208zM208 352c79.5 0 144-64.5 144-144s-64.5-144-144-144S64 128.5 64 208s64.5 144 144 144z"></path>
				</svg>
				<svg class="<?php echo esc_attr( $this->bemSub( 'toggle-icon-close' ) ) ?>" aria-hidden="true"
				     role="img"
				     xmlns="http://www.w3.org/2000/svg" viewBox="0 0 320 512">
					<path fill="currentColor"
					      d="M404.971 449.263c14.874 14.873 14.874 39.004 0 53.88s-39.005 14.873-53.88 0L163.512 314.165-25.4 503.08c-14.873 14.873-39.005 14.873-53.88 0s-14.873-39.005 0-53.88L109.696 260.35-79.332 70.009c-14.873-14.874-14.873-39.005 0-53.88s39.005-14.873 53.88 0l188.964 190.405L352.425 17.62c14.873-14.873 39.005-14.873 53.88 0s14.873 39.005 0 53.88L217.329 260.35 404.97 449.262z" />
				</svg>
			</span>
		</button>
	<?php
	endif; ?>
</div>