<?php

namespace ForgeSmith\Blocks;

use ForgeSmith\FoundryBlock;
use WP_Block;
use WP_Block_List;

class MixedContentBlock extends FoundryBlock {
	public $bemClass = 'fndry-mixed-content';

	public $innerBlocks = [];

	public function __construct( $attributes, $content = '', $wp_block = '' ) {
		parent::__construct( $attributes, $content, $wp_block );

		$this->innerBlocks = $this->getAttribute( 'innerBlocks' ) ?? [];
		if ( ! empty( $this->innerBlocks ) ) {
			$convertedBlocks = array_map( [ $this, 'transformBlock' ], $this->innerBlocks );
			$convertedBlocks = array_filter( $convertedBlocks );

			$this->innerBlocks = $convertedBlocks;
		}
	}
}
