<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
global $fndryGoogleMapsApiKey;

use ForgeSmith\Foundry;

$instance = Foundry::instance();

$fndryGoogleMapsApiKey = $instance->getOption( 'mapsApiKey' );

$myLoc = $this->getAttribute( 'locations' );

// don't do anything if $myLoc is null or []
if ( ! is_array( $myLoc ) || empty( $myLoc ) ) {
	return null;
}

$newLocations = [];

$height = $this->attribute( 'height' );

$heightAll = $height['all'] ?? 'auto';
$heightMd  = $height['md'] ?? 'auto';
$heightSm  = $height['sm'] ?? 'auto';

foreach ( $myLoc as $loc ) {
	$locOption  = $instance->getOptionById( $loc );
	$infoWindow = $locOption['infoWindow'] ?? false;
	if ( isset( $locOption['address'] ) || isset( $locOption['position'] ) ) {
		isset( $infoWindow['linkStyle'] ) and $infoWindow['linkStyle'] = $instance->maybeGetSettingKey( $infoWindow['linkStyle'] );

		$newLocations[] = array_filter(
			[
				'position'   => wp_json_encode( $locOption['position'] ),
				'marker'     => isset( $locOption['marker'] ) && $locOption['marker'] ? wp_get_attachment_image_url( $locOption['marker'],
					"full" ) : null,
				'infoWindow' => $infoWindow && array_filter( $infoWindow ) ? $infoWindow : false,
			]
		);
	}
}

$zoom     = $this->getAttribute( "zoom" );
$mapType  = $this->getAttribute( "mapType" );
$mapWidth = $this->getAttribute( "width" );

if ( ! $fndryGoogleMapsApiKey ) {
	if ( is_user_logged_in() ) {
		echo "No API Key";
	}

	return;
} ?>
<section class="<?php
$this->rootClasses() ?>"
         style="width: <?php
         echo esc_attr($mapWidth); ?>;">
	<div class="<?php echo esc_attr($this->bemSub( 'map-wrapper' )); ?>">
		<div <?php fndry_atts( [
			'data-fndry-js'            => 'map',
			'class'                    => $this->bemSub( 'fndry-map' ),
			'id'                       => "map" . $this->getAttribute( 'fndryBlockId' ),
			'data-locations'           => base64_encode( wp_json_encode( $newLocations ) ),
			'data-map-style'           => $this->attribute( 'mapStyle' ) ? base64_encode( wp_json_encode( json_decode( $this->attribute( 'mapStyle' ) ) ) ) : false,
			'data-disable-default-u-i' => ! ! $this->attribute( 'disableDefaultUI' ),
			'data-zoom-map'            => $zoom,
			'style'                    => [
				'--map-height-all' => $heightAll,
				'--map-height-md'  => $heightMd,
				'--map-height-sm'  => $heightSm,
			],
		] ); ?> ></div>
	</div>
	<?php

	global $apiCalled;
	if ( ! $apiCalled ) :
		$apiCalled = true;
		$mapUrl    = 'https://maps.googleapis.com/maps/api/js?key=' . $fndryGoogleMapsApiKey . '&callback=initMap';
		?>
		<script defer
		        src="<?php
		        echo esc_attr($mapUrl) ?>">
		</script>
	<?php
	endif; ?>
</section>