<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

$headingStyle = $this->attribute( "headingStyle" );
$alignIcon    = $this->attribute( "alignIcon" );
$justifyIcon  = $this->attribute( "justifyIcon" );

$addtlResponsive = $this->renderResponsiveAttributes( [
	'fndry/childPadding' => 'padding',
	'fndry/alignIcon'    => 'align',
	'fndry/justifyIcon'  => 'justify',
], false );

?>
<div <?php fndry_atts( [
	'class' => $this->rootClasses( [ $addtlResponsive ], false ),
	'style' => [
		$this->doBorderStyles( $this->getContext( 'fndry/border' ) )
	],
] ) ?> >
	<?php
	if ( $this->attribute( "url" ) ) : ?>
    <a class="<?php echo esc_attr( $this->bemSub( 'link' ) ) ?>"
       href="<?php echo esc_attr( $this->attribute( "url" ) ); ?>"
       target="<?php
	   echo esc_attr( $this->attribute( "linkTarget" ) ); ?>">
		<?php
		endif;
		if ( $this->attribute( "imageId" ) ) : ?>
            <div class="<?php echo esc_attr( $this->bemSub( 'logo' ) ) ?>">
				<?php
				echo wp_get_attachment_image( $this->attribute( "imageId" ),
					'medium',
					false,
					[ 'class' => $this->bemSub( 'img' ) ] ); ?>
            </div>
		<?php
		endif;
		if ( $this->attribute( "url" ) ) : ?>
    </a>
<?php
endif; ?>
</div>
