<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
$content = $this->getAttribute( 'content' );
if ( empty( $content ) && empty( $this->innerBlocks ) ) {
	return null;
}
$markerContent = $this->attribute( 'markerContent' ) ?: $this->getContext( 'markerContent' );
$style         = $this->attribute( 'textStyle' ) ?: $this->context( 'textStyle' );
$markerColor   = $this->attribute( 'markerColor' );

?>
<li
	<?php
	fndry_atts(
		[
			'class' => [ $this->rootClasses( [ $style ], false ) ],
			'style' => [
				'--fndry-list-marker-color' => $markerColor,
			],
		]
	) ?>>
	<?php
	if ( $markerContent && $this->getContext( 'useCustomMarker' ) ) : ?>
		<span class="<?php echo esc_attr($this->bemSub( 'icon' )) ?>">
			<?php echo wp_kses_post($markerContent) ?>
		</span>
	<?php
	endif;
	echo wp_kses_post($this->getAttribute( 'content' ));
	$this->renderInnerBlocks( [
		'textStyle' => $this->getContext( 'textStyle' ),
	] ) ?>
</li>
