<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
$type        = $this->attribute( 'ordered' ) ? 'ol' : 'ul';
$rootClasses = $this->rootClasses(
	[
		$this->bemMod( 'custom', $this->attribute( 'useCustomMarker' ) ),
		$this->bemMod( 'ordered', $this->attribute( 'ordered' ) ),
	],
	false );

$atts = fndry_atts( [
	'class' => $rootClasses,
	'style' => [
		'--fndry-list-marker-color' => $this->attribute( 'markerColor' ) ?: null,
		'--fndry-list-padding'      => $this->attribute( 'padding' ),
		'--color'                   => $this->attribute( 'textColor' ),
		'--gap'                     => $this->attribute( 'gap' ),
	],
], false);

echo "<$type $atts>";
$this->renderInnerBlocks(
	[ 'textStyle' => $this->attribute( 'textStyle' ) ?: $this->context( 'textStyle' ) ]
);
echo "</$type>";
