<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly
$imageId    = $this->attribute( 'imageId' );
$link       = $this->attribute( 'url' );
$disableAlt = $this->getAttribute( 'disableAlt' );

$alt = $disableAlt
	? ''
	: ( $this->getAttribute( 'imageAlt' )
		?: get_post_meta( $imageId,
			'_wp_attachment_image_alt',
			true ) );

if ( $disableAlt || empty( $alt ) ) {
	$aria_hidden = 'true';
	$role        = 'presentation';
} else {
	$aria_hidden = null;
	$role        = null;
}

$linkAtts = fndry_atts(
	[
		'href'   => $link,
		'target' => $this->getAttribute( 'newTab' ) ? '_blank' : null,
		'class'  => [ $this->bemSub( 'link' ) ],
	],
	false
);

$captionProps = $this->renderResponsiveAttributes( [ 'paddingCaption', 'marginCaption' ], false );
$captionColor = $this->attribute( "captionColor" );
$captionStyle = $this->attribute( 'captionStyle' );
?>
<figure <?php
fndry_atts( [
	'class'           => [ $this->rootClasses( [], false ) ],
	'style'           => [
		'--imageWidth'     => $this->getAttribute( 'width' ),
		'--img-height-all' => $this->getAttribute( 'height.all' ),
		'--img-height-md'  => $this->getAttribute( 'height.md' ),
		'--img-height-sm'  => $this->getAttribute( 'height.sm' ),
	],
	'aria-labelledby' => 'img-' . $imageId,
] ) ?>>
	<?php
	echo $link ? "<a$linkAtts>" : null;

	$width  = $this->getAttribute( 'width' );
	$height = $this->getAttribute( 'height.all' );
	// only use width & height array if the user has provided specific values for each.
	$canUseWidthHeight = ! ! $width && ! ! $height && str_contains( $width, 'px' ) && str_contains( $height, 'px' );

	$imageSize = $canUseWidthHeight ? [
		(int) $width,
		(int) $height,
	] : 'full';

	echo wp_get_attachment_image(
		$imageId,
		$imageSize,
		false,
		[
			'alt'         => $alt,
			'aria-hidden' => $aria_hidden,
			'role'        => $role,
			'class'       => [ $this->bemSub( 'img' ), $this->renderResponsiveProps( 'padding' ) ],
			'data-lity'   => $this->getAttribute( 'lity' ),
			'style'       => array_merge( [
				'--borderRadius' => $this->getAttribute( 'borderRadius' ),
				'--objectFit'    => $this->getAttribute( 'imageFit' ),
				'--imagePosX'    => $this->getAttribute( 'focalPoint.x' ) !== null ? $this->getAttribute( 'focalPoint.x' ) * 100 . '%' : null,
				'--imagePosY'    => $this->getAttribute( 'focalPoint.y' ) !== null ? $this->getAttribute( 'focalPoint.y' ) * 100 . '%' : null,
			], $this->doCSSFilters( $this->getAttribute( 'filters' ) ) ),
		]
	); ?>
	<?php
	echo $link ? '</a>' : null ?>
	<?php
	$imageAlt     = $this->getAttribute( 'imageAlt' );
	$showImageAlt = $this->getAttribute( 'showImageAlt' );

	// Get the existing alt text from WordPress if imageAlt is empty
	if ( empty( $imageAlt ) && $imageId ) {
		$image_alt = get_post_meta( $imageId, '_wp_attachment_image_alt', true );
	}

	if ( $showImageAlt && ! empty( $imageAlt ) ) { ?>
        <figcaption <?php
		fndry_atts( [
			'id'    => [ 'img-' . $imageId ],
			'class' => [
				$this->bemSub( 'caption' ),
				$captionProps,
				$captionStyle,
			],
			'style' => [
				$this->applyPositioning( 'captionPositionProps' ),
				'--color' => $captionColor,
			],
		] ) ?>>
			<?php echo esc_html( $imageAlt ) ?>
        </figcaption>
		<?php
	} ?>
</figure>
