<?php

namespace ForgeSmith\Blocks;
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
use ForgeSmith\FoundryBlock;

class Image extends FoundryBlock {
	public $bemClass = 'fndry-image';

	protected array $deprecations = [
		'height' => [ self::class, 'handleHeightDep' ],
	];

	protected static function handleHeightDep( $value ): array {
		if ( is_string( $value ) ) {
			return [
				'all' => $value,
			];
		}

		return $value;
	}
}