<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
$addtlResponsive = $this->renderResponsiveAttributes( [ 'fndry/childSpacing' => 'padding' ], false );
$root            = $this->rootClasses( [ $addtlResponsive ], false );
$url             = $this->attribute( 'url' );
$target          = $this->attribute( 'linkTarget' );
$style           = $this->getContext( 'fndry/linkStyle' );

$tag      = $style === 'is-link' && $url ? "a" : "div";
$hrefAtts = $style === 'is-link' && $url ? "href='$url' target=''" : null;

$img = wp_get_attachment_image( $this->attribute( "imageId" ), 'full', false, [ 'class' => $this->bemSub( 'image' ) ] );

$padding      = $this->renderResponsiveAttributes( [ 'fndry/childPadding' => 'padding' ], false );
$alignIcon    = $this->renderResponsiveAttributes( [ 'fndry/alignIcon' => 'align' ], false );
$justifyIcon  = $this->renderResponsiveAttributes( [ 'fndry/justifyIcon' => 'justify' ], false );
$innerClasses = fndry_atts( [ 'class' => [ $padding, $this->bemSub( 'inner' ), $alignIcon, $justifyIcon ] ], false );

?>
<div class='<?php echo esc_attr( $root ) ?>'>
	<?php
	echo "<$tag $innerClasses $hrefAtts>";
	if ( $img ) : ?>
		<div class="<?php echo esc_attr( $this->bemSub( 'image-wrapper' ) ) ?>">
			<?php echo wp_kses_post( $img ) ?>
		</div>
	<?php
	endif; ?>
	<div <?php fndry_atts(
		[
			'class' => [
				$this->bemSub( 'content' ),
				$this->renderResponsiveAttributes(
					[
						'fndry/childSpacing'   => 'padding',
						'fndry/alignContent'   => 'align',
						'fndry/justifyContent' => 'justify',
					],
					false ),
			],
		]
	) ?>>
		<?php
		$this->renderInnerBlocks(); ?>
	</div>
	<?php echo "</$tag>"; ?>
</div>