<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
use ForgeSmith\Foundry;

$instance = Foundry::instance();
$baseAtts = [
	'id'    => $this->getAttribute( 'anchor' ),
	'class' => $this->rootClasses( [
		'fndry-responsive-bg',
		$this->renderResponsiveAttributes( [ 'fndry/columnPadding' => 'padding' ],
			false ),
	], false ),
	'style' => array_merge([
		'position'      => $this->getAttribute( 'position' ),
		$this->doBorderStyles( $this->attribute( 'border' ) ),
		'border-radius' => $this->getAttribute( 'borderRadius' ),
		'box-shadow'    => $this->attribute( 'boxShadow' ),
	], $this->renderBackground()),
];

$parallaxEnabled = ! ! $instance->getOption( 'parallaxEnabled' ) && $this->getAttribute( 'parallax.enabled' );
$parallaxAtts    = $parallaxEnabled ? [
	'data-scroll'           => $this->getAttribute( 'parallax.enabled' ),
	'data-scroll-speed'     => ! ! $this->getAttribute( 'parallax.speed' ) ? max( - 1,
		min( 2, $this->getAttribute( 'parallax.speed' ) ) ) : 0,
	'data-scroll-direction' => $this->getAttribute( 'parallax.direction' ),
	'data-scroll-class'     => $this->bemMod( 'parallax-in' ),
] : [];
?>
<div <?php fndry_atts( array_merge( $baseAtts, $parallaxAtts ) ) ?>>
	<?php
	$this->renderInnerBlocks() ?>
</div>
