<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly
$newTab     = $this->getAttribute( "newTab" );
$noreferrer = $this->getAttribute( "noreferrer" );
$noopener   = $this->getAttribute( "noopener" );
$role       = $this->getAttribute( 'role' ) ?: $this->getContext( 'foundry/buttonRole' );
$style      = $this->attribute( 'classMod' ) ?: $this->context( 'fndry/buttonStyle' );

$url         = $this->attribute( "url" ) ?? $this->context( "url" );
$usePostLink = $this->attribute( "usePostLink" );

if ( ! $url && $usePostLink && $this->getContext( 'postId' ) ) {
	$url = $usePostLink ? get_permalink( $this->getContext( 'postId' ) ) : $url;
}

$isButton = in_array( $role, [ 'submit', 'button' ] );

$text = fndry_strip_tags( (string) $this->attribute( "text" ),
	[ 'b', 'br', 'span', 'sub', 's', 'svg', 'em', 'i', 'strong', 'mark' ] );

$atts = [
	'class' => $this->renderBlockProps( [], false ),
];

if ( $isButton ) {
	$atts['role'] = $role;
} else {
	$isPopup = $this->getAttribute( 'isPopup' );
	$id      = $this->getAttribute( 'fndryBlockId' );
	$modalID = "modal-$id";
	$atts    = array_merge( [
		'href'             => $url,
		'rel'              => [ $noreferrer ? 'noreferrer' : false, $noopener ? 'noopener' : false ],
		'target'           => $newTab ? 'blank' : false,
		'data-lity'        => $isPopup,
		'data-lity-target' => $isPopup ? $url : false,
		'data-modal'       => $isPopup ? $modalID : false,
		'id'               => $isPopup ? "modal-toggle-$id" : $id,
		'aria-controls'    => $isPopup ? $modalID : false,
		'onclick'          => $isPopup ? 'javascript:void(0)' : false,
	], $atts );
}

// phpcs:disable WordPress.Security.EscapeOutput.OutputNotEscaped
echo $this->renderButton(
	$text,
	$this->getAttribute( 'classMod' ) ?: $this->getContext( 'fndry/buttonStyle' ),
	$atts,
	$isButton ? 'button' : 'a'
);
// phpcs:enable WordPress.Security.EscapeOutput.OutputNotEscaped