<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
$textAlign     = $this->attribute( "textAlign" );
$textColor     = $this->attribute( "textColor" );
$textTransform = $this->attribute( "textTransform" ) !== "" ? "text-transform: " . $this->attribute( "textTransform" ) . ";" : "";

?>
<figure <?php fndry_atts(
	[
		'class' => $this->rootClasses( [ $this->bemMod( $this->attribute( 'style' ) ), $this->bemMod( $textAlign ) ],
			false ),
		'style' => [
			'--color'          => $textColor,
			'--styleColor'     => $this->attribute( "style" ) !== "quote-style-default" ? $this->attribute( 'borderColor' ) : false,
			'--fndry-quote-bl' => $this->attribute( "style" ) !== "quote-style-default" ? $this->attribute( 'borderWidth' ) : false,
		],
	]
) ?>>
	<blockquote class="<?php echo esc_attr( $this->bemSub( 'quote' ) ) ?>">
		<p class="<?php
		echo esc_attr( $this->attribute( "quoteStyle" ) ); ?>">
			<?php
			echo wp_kses_post( $this->getAttribute( "quote" ) ); ?>
		</p>
	</blockquote>
	<figcaption <?php fndry_atts(
		[ 'class' => [ $this->bemSub( 'citation' ), $this->attribute( 'citeStyle' ) ], ]
	) ?>>
		<?php
		echo wp_kses_post( $this->getAttribute( "citation" ) ); ?>
	</figcaption>
</figure>