<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
$tax = is_archive() ? get_queried_object()->taxonomy : $this->getAttribute( 'taxonomy' );
if ( ! $tax || ! taxonomy_exists( $tax ) ) {
	return null;
}

$taxOb = get_taxonomy( $tax );

$terms = get_terms( [
	'taxonomy'   => $tax,
	'hide_empty' => ! ! $this->getAttribute( 'hideEmpty' ),
] );

$termsList = '';

if ( $this->getAttribute( 'showLabel' ) ) {
	$termsList .= fndry_string(
		$taxOb->label,
		'li',
		[
			'class' => [
				$this->bemSub( 'tax-label' ),
				$tax,
				$this->attribute( 'labelStyle' ),
			],
		],
		false
	);
}

if ( $this->getAttribute( 'showAll' ) &&
     ! ! ( $postType = $taxOb->object_type[0] ?? '' ) &&
     ! ! ( $url = $this->getAttribute( 'showAllLink.id' ) ? get_permalink( $this->getAttribute( 'showAllLink.id' ) ) : get_post_type_archive_link( $postType ) )
) {
	$link = $this->renderButton(
		'Show All',
		get_the_permalink() === $url || is_post_type_archive( $postType ) ?
			$this->getAttribute( 'activeBtnClass' ) :
			$this->getAttribute( 'btnClass' ),
		[
			'class' => [
				$this->bemSub( 'term-link' ),
				$this->bemSub( 'term-link--show-all' ),
			],
			'href'  => $url,
		],
		'a'
	);

	$termsList .= fndry_string( $link, 'li', [
		'class' => [
			$this->bemSub( 'term' ),
			$this->bemSub( 'term--show-all' ),
			"taxonomy-$tax",
		],
	], false );
}

foreach ( $terms as $term ) {
	$link = $this->renderButton(
		$term->name,
		is_archive() && get_queried_object()->slug === $term->slug ?
			$this->getAttribute( 'activeBtnClass' ) :
			$this->getAttribute( 'btnClass' ),
		[
			'class' => [
				$this->bemSub( 'term-link' ),
				$this->bemSub( 'term-link--show-all' ),
			],
			'href'  => get_term_link( $term->term_id ),
		],
		'a'
	);

	$termsList .= fndry_string( $link, 'li', [
		'class' => [
			$this->bemSub( 'term' ),
			"taxonomy-$tax",
			"term-" . $term->term_id,
		],
	], false );
} ?>
<?php
$scrollShadow = $this->getAttribute( 'scrollShadow' );
if ( $scrollShadow ) : ?>
<div class="scroll-shadow-wrapper">
	<?php endif; ?>

	<?php
	fndry_string( $termsList, 'ul', [
		'class' => [
			$this->rootClasses( [], false ),
			$scrollShadow ? 'scroll-shadow' : '',
		],
		'style' => [
			'--gap' => $this->getAttribute( 'gap' ),
		],
	]);
	?>

	<?php if ( $scrollShadow ) : ?>
</div>
<?php endif; ?>

