<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

$iconStyle              = $this->getContext( 'fndry/iconStyle' );
$alignItems             = $this->getContext( 'fndry/alignItems' );
$showCollapseExpandText = $this->getContext( 'fndry/showCollapseExpandText' );

$labelMainWidth = $this->getContext( 'fndry/labelMainWidth' ) === 'custom' ? $this->getContext( 'fndry/labelMainCustomWidth' ) : $this->getContext( 'fndry/labelMainWidth' );
$labelSecWidth  = $this->getContext( 'fndry/labelSecWidth' ) === 'custom' ? $this->getContext( 'fndry/labelSecCustomWidth' ) : $this->getContext( 'fndry/labelSecWidth' );
$labelTertWidth = $this->getContext( 'fndry/labelTertWidth' ) === 'custom' ? $this->getContext( 'fndry/labelTertCustomWidth' ) : $this->getContext( 'fndry/labelTertWidth' );

$isFirstOpen = $this->getContext( 'fndry/accordionItemFirstOpen' ) && $this->getContext( 'fndry/innerBlockIndex' ) === 0;

$heading_tag           = $this->context( 'fndry/labelLevel' ) ?: 3;
$subheading_tag       = $this->context( 'fndry/labelSubLevel' ) ?: 4;
$second_subheading_tag = $this->context( 'fndry/secondLabelSubLevel' ) ?: 4;

?>
<div <?php
fndry_atts( [
	'class'                      => $this->rootClasses( [], false ),
	'data-fndry-accordion-index' => $this->getContext( 'fndry/innerBlockIndex' ),
	'id'                         => $this->getAttribute( 'anchor' ),
] ) ?>>
	<div
		<?php
		fndry_atts( [
			'class'         => [
				$this->bemSub( 'entry' ),
				$this->renderResponsiveAttributes( [ 'fndry/itemMargin' => 'margin' ], false ),
			],
			'style'         => [
				$this->doBorderStyles( $this->getContext( 'fndry/border' ) ),
				'border-radius' => $this->getContext( 'fndry/borderRadius' ),
			],
			'data-fndry-js' => 'accordion-entry',
		] ) ?>>
		<button
			<?php
			fndry_atts(
				[
					'class'         => [
						$this->renderResponsiveAttributes( [ 'fndry/labelPadding' => 'padding' ], false ),
						$this->bemSub( 'label' ),
						"fndry-align--$alignItems",
						'fndry-accordion-block__label--open' => $isFirstOpen,
					],
					'data-fndry-js' => 'accordion-label',
				]
			) ?>>
			<span
			<?php
			fndry_atts(
				[
					'class' => [
						$this->bemSub( 'label-container' ),
						$this->renderResponsiveAttributes( [
							'fndry/labelDisplay' => 'display',
							'fndry/labelAlign'   => 'align',
							'fndry/labelJustify' => 'justify',
							'fndry/labelFlex'    => 'flex',
						], false ),
					],
					'style' => [
						'--fndryLabelGap' => $this->getContext( 'fndry/labelGap' ),
					],
				]
			) ?>>
				<?php
				fndry_string( $this->attribute( 'heading' ), 'h' . $heading_tag, [
					'class' => [
						$this->bemSub( 'label-heading' ),
						$this->context( "fndry/labelStyle" ),
						$this->renderResponsiveAttributes( [
							'fndry/labelMainMargin' => 'margin',
						], false ),
					],
					'style' => [
						'color'                           => $this->context( 'fndry/labelColor' ),
						'--fndry-accordion-heading-width' => $labelMainWidth,
					],
				] );
				fndry_string( $this->attribute( 'subHeading' ), 'h' . $subheading_tag, [
					'class' => [
						$this->bemSub( 'label-subheading' ),
						$this->context( "fndry/labelSubStyle" ),
						$this->renderResponsiveAttributes( [
							'fndry/labelSecMargin' => 'margin',
						], false ),
					],
					'style' => [
						'color'                              => $this->context( 'fndry/firstExtraLabelColor' ),
						'--fndry-accordion-subheading-width' => $labelSecWidth,
					],
				] );
				fndry_string( $this->attribute( 'secondarySubHeading' ), 'h' . $second_subheading_tag, [
					'class' => [
						$this->bemSub( 'label-secondary-subheading' ),
						$this->context( "fndry/secondLabelSubStyle" ),
						$this->renderResponsiveAttributes( [
							'fndry/labelTertMargin' => 'margin',
						], false ),
					],
					'style' => [
						'color'                                        => $this->context( 'fndry/secondExtraLabelColor' ),
						'--fndry-accordion-secondary-subheading-width' => $labelTertWidth,
					],
				] ); ?>
			</span>
			<?php

			if ( $showCollapseExpandText ) {
				fndry_string(
					$this->getContext( 'fndry/expandText' ),
					'span',
					[
						'class' => [
							$this->bemSub( 'label-accessibility' ),
							'expand-text',
							$this->bemSub( 'label-accessibility--hidden' ) => $isFirstOpen,
						],
					]
				);
				fndry_string(
					$this->getContext( 'fndry/collapseText' ),
					'span',
					[
						'class' => [
							$this->bemSub( 'label-accessibility' ),
							'collapse-text',
							$this->bemSub( 'label-accessibility--hidden' ) => ! $isFirstOpen,
						],
					]
				);
			}

			if ( $iconStyle === 'shortcode' ) : ?>
				<div class="<?php
				echo esc_attr( $this->bemSub( 'icon-wrap' ) ) ?>">
					<div class="<?php
					echo esc_attr( $this->bemSub( 'icon-inner' ) ) ?>">
						<div class="<?php
						echo esc_attr( $this->bemSub( 'icon-front' ) ) ?>">
							<?php
							echo wp_kses_post( $this->getContext( 'fndry/iconShortcodeOpen' ) ) ?>
						</div>
						<div class="<?php
						echo esc_attr( $this->bemSub( 'icon-back' ) ) ?>">
							<?php
							echo wp_kses_post( $this->getContext( 'fndry/iconShortcodeClose' ) ) ?>
						</div>
					</div>
				</div>
			<?php
			elseif ( $iconStyle === 'rotate' ) : ?>
				<svg class="<?php
				echo esc_attr( $this->bemSub( 'icon' ) . ' ' . $this->bemSub( 'icon' ) . '--rotate' ) ?>"
				     aria-hidden="true"
				     xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512">
					<path fill="currentColor"
					      d="M432 256c0 13-11 24-24 24H248v160a24 24 0 0 1-48 0V280H40a24 24 0 1 1 0-48h160V72a24 24 0 0 1 48 0v160h160c13 0 24 11 24 24z"/>
				</svg>
			<?php
			else : ?>
				<svg class="<?php
				echo esc_attr( $this->bemSub( 'icon' ) ) ?>" viewBox="0 0 448 512">
					<path
						d="m443.5 162.6-7.1-7.1a12 12 0 0 0-17 0L224 351 28.5 155.5a12 12 0 0 0-17 0l-7.1 7.1a12 12 0 0 0 0 17l211 211.1a12 12 0 0 0 17 0l211-211.1a12 12 0 0 0 .1-17z"
						fill="currentColor"/>
				</svg>
			<?php
			endif; ?>

		</button>

		<div
			<?php
			fndry_atts( [
				'class'         => [
					$this->bemSub( 'content' ),
					'fndry-collapse--hidden' => ! $isFirstOpen,
				],
				'data-fndry-js' => 'accordion-content',
			] ) ?>
		>
			<div <?php
			fndry_atts( [
				'class' => [
					$this->renderResponsiveAttributes( [ 'fndry/accordionPadding' => 'padding' ], false ),
					$this->bemSub( 'body' ),
				],
			] ) ?>>
				<?php
				$this->renderInnerBlocks(); ?>
			</div>
		</div>
	</div>
</div>
