<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

/**
 * Because we have some sites using customizations based off of functions contained within this plugin,
 * add some fallbacks here so they don't get errors when they update.
 */

if ( ! function_exists( 'doAtts' ) ) {
	function doAtts( $atts, $string = true ) {
		// doAtts never echoed. do nothing with $string.
		return fndry_atts( $atts, false );
	}
}

if ( ! function_exists( 'doString' ) ) {
	function doString( $field, string $tag = "p", $atts = null, $echo = true ) {
		return fndry_string( $field, $tag, $atts, $echo );
	}
}

if ( ! function_exists( 'getQueryVar' ) ) {
	function getQueryVar( $var ) {
		return fndry_get_query_var( $var );
	}
}

if ( ! function_exists( 'recursiveSelectChildren' ) ) {
	function recursiveSelectChildren( $category, $depth, $selected, $post_type = null, $displayCount = false ) {
		return fndry_recursive_select_children( $category, $depth, $selected, $post_type, $displayCount );
	}
}
if ( ! function_exists( 'recursiveInputGroup' ) ) {
	function recursiveInputGroup(
		WP_Term $category,
		string $queryVar,
		bool|null $selected,
		string|null $post_type = null,
		bool|int $displayCount = false,
		bool $hierarchical = false,
		string $type = 'checkbox',
		bool $collapsible = false,
		string|null $parentSlug = null,
		int $depth = 0
	) {
		return fndry_recursive_input_group(
			$category,
			$queryVar,
			$selected,
			$post_type,
			$displayCount,
			$hierarchical,
			$type,
			$collapsible,
			$parentSlug,
			$depth
		);
	}
}
