<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly
require_once 'FoundrySettings.php';

/* global stuff like excerpt generation */
require_once "hooks/wp-overrides.php";
require_once "hooks/shortcode-fix.php";

/* backwards compat to fndry settings changes */
require_once "hooks/options-compat.php";

/* extensions - adding block features etc */
require_once "hooks/ext-sticky-support.php";
require_once "hooks/ext-block-meta.php";

use ForgeSmith\Foundry;


add_action( 'init', function () {
	$instance = Foundry::instance();
	$instance->registerBlocks( [
		'Accordion',
		'AccordionBlock',
		'ArchiveList',
		'Blockquote',
		'Button',
		'ColumnBlock',
		'ContainerBlock',
		'Heading',
		'IconPost',
		'IconPostBlock',
		'Image',
		'ListBlock',
		'ListItem',
		'LogoGrid',
		'LogoGridBlock',
		'MapBlock',
		'NavSearch',
		'Navigation',
		'NavigationLink',
		'NavigationSubmenu',
		'Paragraph',
		'PostAuthor',
		'PostAuthorName',
		'PostAuthorBio',
		'PostAuthorAvatar',
		'PostDate',
		'PostExcerpt',
		'PostFeaturedImage',
		'PostNavLink',
		'PostTerms',
		'PostTitle',
		'QueryBlock',
		'QueryAdvancedFilter',
		'QueryFilter',
		'QueryFilterDropdowns',
		'QueryFilterSearch',
		'QueryNoResults',
		'QueryPagination',
		'QueryPaginationNext',
		'QueryPaginationNumbers',
		'QueryPaginationPrev',
		'QueryPostTemplate',
		'RelatedPosts',
		'RowBlock',
		'Slideout',
		'SlideoutBlock',
		'SliderBlock',
		'SliderControlsNext',
		'SliderControlsPrev',
		'SliderControlsPills',
		'SliderItem',
		'SliderQueryTrack',
		'SliderTrack',
		'SliderV2',
		'SocialLink',
		'SocialList',
		'Statistics',
		'StatisticsBlock',
		'Tabs',
		'TabsBlock',
		'VideoPopup',
		'SearchResultsTitle',
	] );
	$instance->init();
	\ForgeSmith\FoundrySettings::instance()->init();
}, 20 );

if ( ! defined( 'REFOUNDRY_PRO_DIR' ) ) {
	\ForgeSmith\FoundrySettings::instance()->pages[] = [
		'text' => 'Pro Upgrade',
		'id' => 'https://refoundry.io/pricing/'
	];
	\ForgeSmith\FoundrySettings::instance()->moreLinks[] =
		'<a class="fndry-settings-nav__upgrade" href="https://refoundry.io/pricing/" target="_blank">
			Pro Upgrade
			<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512" class="fndry-settings-nav__upgrade--icon">
                <path d="M320 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l82.7 0L201.4 265.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0L448 109.3l0 82.7c0 17.7 14.3 32 32 32s32-14.3 32-32l0-160c0-17.7-14.3-32-32-32L320 0zM80 32C35.8 32 0 67.8 0 112L0 432c0 44.2 35.8 80 80 80l320 0c44.2 0 80-35.8 80-80l0-112c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 112c0 8.8-7.2 16-16 16L80 448c-8.8 0-16-7.2-16-16l0-320c0-8.8 7.2-16 16-16l112 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L80 32z"></path>
            </svg>
        </a>';
}