<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly


if ( defined( 'REST_REQUEST' ) && REST_REQUEST ) {
	exit;
} // exit if part of REST - we don't care about this fix outside the front-end;
/*
 * https://github.com/WordPress/wordpress-develop/commit/c25e29ce9bcc03b1c3fc66a7b870f2ddbf37708b
 * this broke shortcodes being processed AFTER do_blocks
 * code below is intended as a stopgap until they fix it. its ugly, inefficient.
 *
 * no idea when this will get fixed, we're now a couple versions after the initial report and its still patchwork;
 * */
function fndry_parse_inner_blocks( &$parsed_block ) {
	if ( isset( $parsed_block['innerBlocks'] ) ) {
		foreach ( $parsed_block['innerBlocks'] as $key => &$inner_block ) {
			if ( ! empty( $inner_block['innerContent'] ) ) {
				foreach ( $inner_block['innerContent'] as &$inner_content ) {
					if ( empty( $inner_content ) ) {
						continue;
					}

					$inner_content = do_shortcode( $inner_content );
				}
			}
			if ( isset( $inner_block['innerBlocks'] ) ) {
				$inner_block = fndry_parse_inner_blocks( $inner_block );
			}
		}
	}

	return $parsed_block;
}

/**
 * Only do_shortcodes for actual strings.
 * 1.7.3 - Fix ternary fallback casting non-arrays as strings;
 *
 * @param $attrs
 *
 * @return array|mixed|string|string[]
 */
function fndry_recursive_shortcode_fix( $attrs ) {
	return is_array( $attrs ) ? array_map( function ( $attr ) {
		return is_string( $attr ) ? do_shortcode( $attr ) : fndry_recursive_shortcode_fix( $attr );
	}, $attrs ) : ( is_string( $attrs ) ? do_shortcode( $attrs ) : $attrs );
}

add_filter( 'render_block_data', function ( $parsed_block ) {
	$parsed_block['attrs'] = fndry_recursive_shortcode_fix( $parsed_block['attrs'] );

	if ( isset( $parsed_block['innerContent'] ) ) {
		foreach ( $parsed_block['innerContent'] as &$inner_content ) {
			if ( empty( $inner_content ) ) {
				continue;
			}

			$inner_content = do_shortcode( $inner_content );
		}
	}

	$parsed_block = fndry_parse_inner_blocks( $parsed_block );

	return $parsed_block;
}, 10, 1 );

add_filter( 'render_block', function ( $parsed_block ) {
	return do_shortcode( $parsed_block );
} );
