<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
// back-compat: unset saved boxShadow objects in buttonStyles
// these were never in use in production anyway, but because of defaults they got saved regardless
add_filter( "option_fndry_component_styles", function ( $option ) {
	if ( isset( $option['buttons']['buttonStyles'] ) ) {
		$option['buttons']['buttonStyles'] = array_map( function ( $style ) {
			if ( isset( $style['boxShadow'] ) && is_array( $style['boxShadow'] ) ) {
				unset( $style['boxShadow'] );
			}

			return $style;
		}, $option['buttons']['buttonStyles'] );
	}

	return $option;
}, 10, 1 );