<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
/*
 * add sticky support.
 * */
function foundry_apply_sticky_support( $block_type, $block_attributes ) {
	$classes = [];
	$headsUpEnabled = isset( $block_attributes['__fndryStickyEnabled'] ) && $block_attributes['__fndryStickyEnabled'];
	if ( $headsUpEnabled ) {
		$classes[] = "fndry-sticky-enabled";
	}
	if ( $headsUpEnabled && isset( $block_attributes['__fndryHeadsUpEnabled'] ) && $block_attributes['__fndryHeadsUpEnabled'] ) {
		$classes[] = "fndry-sticky-enabled--heads-up";
	}

	return [ 'class' => join( ' ', $classes ) ];
}

function foundry_sticky_support( $block_type ) {
	// Setup attributes and styles within that if needed.
	if ( ! $block_type->attributes ) {
		$block_type->attributes = [];
	}
	$block_type->attributes['__fndryHeadsUpEnabled'] = [
		'type' => 'boolean',
	];
	$block_type->attributes['__fndryStickyEnabled']  = [
		'type' => 'boolean',
	];
}

add_action( 'init', function () {
	WP_Block_Supports::get_instance()->register(
		'__fndryStickySupport',
		[
			'register_attribute' => 'foundry_sticky_support',
			'apply'              => 'foundry_apply_sticky_support',
		]
	);
} );