<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
/*
 * Adds necessary addtl attrs and contexts for all blocks.
 * supports:
 * - sticky => enables sticky/headsup for block templates like header/footer; *
 *
 * attrs:
 * - fndryBlockId => used to be useful, now its just a if-necessary uniqid for blocks. not required by anything, really;
 * - reusableCompRefId => this is used by RCBs to marry overrides to their associated blocks. required!;
 *
 * context:
 * - add innerBlockIndex so blocks know where they are in the render tree (e.g. so an accordion item knows if its the first one etc);
 * */

add_filter( 'block_type_metadata', function ( $metadata ) {
	if ( isset( $metadata['name'] ) && $metadata['name'] === 'core/template-part' ) {
		$metadata['supports'] = array_merge( $metadata['supports'], [
			'__fndryStickySupport' => true,
		] );
	}
	if ( isset( $metadata['attributes'] ) && isset( $metadata['name'] ) ) {
		$metadata['attributes'] = array_merge(
			$metadata['attributes'],
			[
				'fndryBlockId' => [
					'type' => 'string',
				],
				'reusableCompRefId' => [
					'type' => 'string',
				],
			]
		);

		// add innerBlock Index
		if ( isset( $metadata['usesContext'] ) ) {
			$metadata['usesContext'] = array_merge( $metadata['usesContext'],
				[ 'fndry/innerBlockIndex', 'isPost', 'postType', 'postId' ] );
		}
	}

	return $metadata;
} );