<?php
// Exit if accessed directly.
use ForgeSmith\Foundry;
use ForgeSmith\FoundrySchema;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
function fndry_render_plugin_settings_header( $reactId = '' ): void {
	$active = str_replace( [ 'refoundry_page_', 'toplevel_page_' ], '', get_current_screen()->id );

	$links = [
		'Settings',
		'Custom Fields',
		'Global Styles',
		'Component Styles',
		'Animations',
	];

	if ( defined( 'REFOUNDRY_PRO_DIR' ) ) {
		$links[] = 'License';
	}

	ob_start();
	?>
	<div class="fndry-settings">
		<div class="fndry-settings-header">
			<div class="fndry-settings-header__logo">
				<svg viewBox="0 0 754 180" fill="none" xmlns="http://www.w3.org/2000/svg" aria-label="Refoundry Logo">
					<path
						d="M114.151 117.236C112.383 117.588 110.561 117.793 108.689 117.793C93.3179 117.793 80.8572 105.353 80.8572 90.0076C80.8572 74.6619 93.3179 62.2216 108.689 62.2216C120.341 62.2216 130.315 69.3728 134.462 79.5169H105.382V96.0108H154.763C155.021 94.0454 155.163 92.0435 155.163 90.0076C155.163 64.383 134.356 43.6102 108.689 43.6102C83.0223 43.6102 62.2152 64.3829 62.2152 90.0076C62.2152 115.632 83.0223 136.405 108.689 136.405C110.538 136.405 112.359 136.286 114.151 136.076V117.236Z"
						fill="#A7B739" />
					<path
						d="M263.621 43.6107V62.2159C278.992 62.2159 291.452 74.6562 291.452 90.0021C291.452 105.348 278.992 117.788 263.621 117.788C248.25 117.788 235.789 105.347 235.789 90.0021H217.153C217.153 115.623 237.957 136.393 263.621 136.393C289.285 136.393 310.089 115.623 310.089 90.0021C310.089 64.3813 289.284 43.6107 263.621 43.6107Z"
						fill="#A7B739" />
					<path
						d="M574.614 1.68188V55.2816C566.801 48.0244 556.529 43.6107 545.266 43.6107C520.816 43.6107 500.994 64.3807 500.994 90.0015C500.994 115.622 520.816 136.393 545.266 136.393C556.529 136.393 566.801 131.979 574.614 124.722V133.863H596.118V1.68188H574.614ZM549.898 117.704C534.527 117.704 522.066 105.264 522.066 89.9185C522.066 74.5727 534.527 62.133 549.898 62.133C565.269 62.133 577.729 74.5727 577.729 89.9185C577.729 105.264 565.269 117.704 549.898 117.704Z"
						fill="#A7B739" />
					<path
						d="M459.954 43.6107C448.474 43.6107 438.368 49.4719 432.463 58.3561V46.1361H410.958V101.667H432.463V81.5799C432.463 70.8389 441.184 62.1324 451.943 62.1324C462.701 62.1324 471.423 70.8388 471.423 81.5799V133.863H492.928V76.5305C492.928 58.349 478.165 43.6107 459.954 43.6107Z"
						fill="#ED145B" />
					<path
						d="M182.034 35.4045V46.1366H203.43V67.6025H182.034V133.863H203.538V67.6025H235.79V46.1366H203.539V35.4045C203.539 27.7205 209.8 21.4691 217.497 21.4691H235.79V0H217.497C197.911 0 182.034 15.8513 182.034 35.4045Z"
						fill="#ED145B" />
					<path
						d="M732.14 46.1366V98.4184C732.14 109.161 723.419 117.868 712.66 117.868C701.901 117.868 693.18 109.161 693.18 98.4184V78.3347H671.675V103.47C671.675 121.651 686.437 136.389 704.649 136.389C716.13 136.389 726.235 130.528 732.14 121.643V144.596C732.14 152.279 725.878 158.531 718.181 158.531H699.889V180H718.181C737.767 180 753.644 164.149 753.644 144.595V133.863L753.645 46.1366H732.14Z"
						fill="#ED145B" />
					<path d="M339.742 46.1365H318.237V67.6024H339.742V46.1365Z" fill="#212121" />
					<path d="M182.034 46.133H160.638V67.6025H182.034V46.133Z" fill="#212121" />
					<path d="M146.302 114.923H124.906V136.393H146.302V114.923Z" fill="#212121" />
					<path d="M432.461 112.4H410.956V133.865H432.461V112.4Z" fill="#212121" />
					<path d="M693.18 46.1365H671.675V67.6019H693.18V46.1365Z" fill="#212121" />
					<path
						d="M549.736 101.967C556.357 101.967 561.724 96.6087 561.724 89.999C561.724 83.3893 556.357 78.031 549.736 78.031C543.115 78.031 537.748 83.3893 537.748 89.999C537.748 96.6087 543.115 101.967 549.736 101.967Z"
						fill="#212121" />
					<path d="M628.372 78.9434H660.923V46.4456C642.945 46.4456 628.372 60.9958 628.372 78.9434Z"
					      fill="#212121" />
					<path d="M235.789 90.0017H263.621V62.2159C248.25 62.2159 235.789 74.6565 235.789 90.0017Z"
					      fill="#212121" />
					<path d="M628.371 46.1356H606.868V133.862H628.371V46.1356Z" fill="#31498C" />
					<path
						d="M378.702 46.1367V98.4185C378.702 109.161 369.981 117.867 359.222 117.867C348.464 117.867 339.742 109.161 339.742 98.4185V78.3359H318.237V103.469C318.237 121.651 333 136.389 351.211 136.389C362.692 136.389 372.797 130.527 378.702 121.643V133.863H400.207V46.1367H378.702Z"
						fill="#31498C" />
					<path d="M21.5035 78.9434H54.0549V46.4457C36.0774 46.4457 21.5035 60.9959 21.5035 78.9434Z"
					      fill="#212121" />
					<path d="M21.5026 46.1356H0V133.862H21.5026V46.1356Z" fill="#31498C" />
				</svg>
			</div>
			<h1 class="fndry-settings-header__title visually-hidden">
				ReFoundry
			</h1>
		</div>
		<nav class="fndry-settings-nav">
			<?php
			foreach ( $links as $link ) :
				// TODO - remove custom fields from Core entirely;
				if ( $link === 'Custom Fields' && ( ! get_option( 'fndry_license_key' ) || get_option( 'fndry_license_status' ) !== 'valid' ) ) {
					continue;
				}

				$slug = "foundry-plugin-" . sanitize_title( $link );
				?>
				<a href="?page=<?php echo esc_attr( $slug ) ?>"
				   class="fndry-settings-nav__nav-item<?php echo $slug === $active ? ' fndry-settings-nav__nav-item--active' : '' ?>">
					<?php echo esc_html( $link ) ?>
				</a>
			<?php
			endforeach;
			if ( ! defined( 'REFOUNDRY_PRO_DIR' ) ) {
				echo '<a class="fndry-settings-nav__upgrade" href="https://refoundry.io/pricing/" target="_blank">
								Pro Upgrade
								<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512" class="fndry-settings-nav__upgrade--icon">
	                                <path d="M320 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l82.7 0L201.4 265.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0L448 109.3l0 82.7c0 17.7 14.3 32 32 32s32-14.3 32-32l0-160c0-17.7-14.3-32-32-32L320 0zM80 32C35.8 32 0 67.8 0 112L0 432c0 44.2 35.8 80 80 80l320 0c44.2 0 80-35.8 80-80l0-112c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 112c0 8.8-7.2 16-16 16L80 448c-8.8 0-16-7.2-16-16l0-320c0-8.8 7.2-16 16-16l112 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L80 32z"></path>
	                            </svg>
  							</a>';
			}
			?>
		</nav>
		<div id="<?php echo esc_attr( $reactId ) ?>"></div>
	</div>
	<?php
	echo ob_get_clean(); //phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped -- escaped by logic above.
}

// registering options page
function foundry_plugin_settings_page() {
	// need this for media uploader to not occasionally fail on load
	wp_enqueue_media();
	// Our main settings page.

	$slug = 'foundry-plugin-settings';
	add_menu_page(
		__( 'Refoundry', 'refoundry-blocks' ),
		__( 'Refoundry', 'refoundry-blocks' ),
		'manage_options',
		$slug,
		null,
		"data:image/svg+xml;base64, PHN2ZyB3aWR0aD0iMTgwIiBoZWlnaHQ9IjE4MCIgdmlld0JveD0iMCAwIDE4MCAxODAiIGZpbGw9Im5vbmUiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+CjxwYXRoIGQ9Ik03OC4yMjczIDY3LjMxNTlIMTQ1LjE3N1YwLjYzNjIzQzEwOC4yMDIgMC42MzYyMyA3OC4yMjczIDMwLjQ5MDcgNzguMjI3MyA2Ny4zMTU5WiIgZmlsbD0id2hpdGUiLz4KPHBhdGggZD0iTTc4LjIyNTUgMEgzNFYxODBINzguMjI1NVYwWiIgZmlsbD0id2hpdGUiLz4KPC9zdmc+Cg==",
	);

	// Get Started page.
	add_submenu_page(
		$slug,
		__( 'Refoundry Plugin Settings', 'refoundry-blocks' ),
		'<span class="fs-submenu-item fs-sub"></span>' . __( 'Settings', 'refoundry-blocks' ),
		'manage_options',
		$slug,
		function () {
			fndry_render_plugin_settings_header( 'foundry-settings-general' );
		}
	);

	// Global Styles page.
	add_submenu_page(
		$slug,
		__( 'Global Styles', 'refoundry-blocks' ),
		'<span class="fs-submenu-item fs-sub"></span>' . __( 'Global Styles', 'refoundry-blocks' ),
		'manage_options',
		'foundry-plugin-global-styles',
		function () {
			fndry_render_plugin_settings_header( 'foundry-settings-global-styles' );
		}
	);

	// Custom Fields page.
	add_submenu_page(
		$slug,
		__( 'Custom Fields', 'refoundry-blocks' ),
		'<span class="fs-submenu-item fs-sub"></span>' . __( 'Custom Fields', 'refoundry-blocks' ),
		'manage_options',
		'foundry-plugin-custom-fields',
		function () {
			fndry_render_plugin_settings_header( 'foundry-settings-custom-fields' );
		}
	);

	// Component Styles page.
	add_submenu_page(
		$slug,
		__( 'Component Styles', 'refoundry-blocks' ),
		'<span class="fs-submenu-item fs-sub"></span>' . __( 'Component Styles', 'refoundry-blocks' ),
		'manage_options',
		'foundry-plugin-component-styles',
		function () {
			fndry_render_plugin_settings_header( 'foundry-settings-component-styles' );
		}
	);

	// Animations page.
	add_submenu_page(
		$slug,
		__( 'Animations', 'refoundry-blocks' ),
		'<span class="fs-submenu-item fs-sub"></span>' . __( 'Animations', 'refoundry-blocks' ),
		'manage_options',
		'foundry-plugin-animations',
		function () {
			fndry_render_plugin_settings_header( 'foundry-settings-animation-settings' );
		}
	);

	// Pro Upgrade link
	if ( ! defined( 'REFOUNDRY_PRO_DIR' ) ) {
		add_submenu_page(
			$slug,
			__( 'Pro Upgrade', 'foundry' ),
			'<span class="fs-submenu-item fs-sub"></span>' . __( 'Pro Upgrade', 'foundry' ),
			'manage_options',
			'https://refoundry.io/pricing/',
		);
	}
}

add_action( 'admin_menu', 'foundry_plugin_settings_page' );

function foundry_plugin_register_settings() {
	// "keys" will be the actual css variable names to simplify usage within templates etc
	// method for generating keys wll be to take the 'name' field and use lodash camelcase
	register_setting(
		'foundry_plugin_settings_page',
		'fndry_global_styles',
		[
			'type'              => 'object',
			'sanitize_callback' => [ Foundry::instance(), 'sanitizeSchema__GLOBAL_STYLES' ],
			'default'           => [
				'colors'     => [
					'primary'   => [
						[
							'hex'     => '#ED145B',
							'name'    => 'Raspberry',
							'key'     => '--fndry-color-raspberry',
							'fndryId' => 'fcp1',
						],
						[
							'hex'     => '#31498C',
							'name'    => 'Marian Blue',
							'key'     => '--fndry-color-marianBlue',
							'fndryId' => 'fcp2',
						],
						[
							'hex'     => '#A7B739',
							'name'    => 'Apple Green',
							'key'     => '--fndry-color-appleGreen',
							'fndryId' => 'fcp3',
						],
					],
					'secondary' => [
						[
							'hex'     => '#ED145B80',
							'name'    => 'Transparent Raspberry',
							'key'     => '--fndry-color-transparentRaspberry',
							'fndryId' => 'fcs3',
						],
						[
							'hex'     => '#31498C80',
							'name'    => 'Transparent Blue',
							'key'     => '--fndry-color-transparentBlue',
							'fndryId' => 'fcs4',
						],
						[
							'hex'     => '#A7B73980',
							'name'    => 'Transparent Green',
							'key'     => '--fndry-color-transparentGreen',
							'fndryId' => 'fc5',
						],
					],
					'neutral'   => [
						[ 'hex' => '#000', 'name' => 'Black', 'key' => '--fndry-color-black', 'fndryId' => 'fcn6' ],
						[ 'hex' => '#fff', 'name' => 'White', 'key' => '--fndry-color-white', 'fndryId' => 'fcn7' ],
						[ 'hex' => '#C5CECE', 'name' => 'Grey', 'key' => '--fndry-color-grey', 'fndryId' => 'fcn8' ],
					],
				],
				'fonts'      => [
					'googleFontsEnabled'     => true,
					'googleFontsImportValue' => [
						[
							'family'   => 'Roboto Mono',
							'import'   => 'Roboto+Mono:ital,wght@0,100;0,300;0,500;0,700;1,500;1,600',
							'fallback' => 'monospace',
						],
						[
							'family'   => 'Roboto',
							'import'   => 'Roboto:ital,wght@0,300;0,500;1,300;1,400;1,500',
							'fallback' => 'sans-serif',
						],
					],
					'adobeFontsEnabled'      => false,
					'adobeFontsImportValue'  => [],
					'fontAwesomeEnabled'     => false,
				],
				'typography' => [
					'bodyStyle'    => [
						'color'       => 'black',
						'family'      => 'var(--fndry-font-robotoMono)',
						'minFontSize' => '1rem',
						'line'        => 1.5,
						'spacing'     => '0rem',
						'weight'      => 500,
					],
					'headerStyles' => [
						[
							'fndryId'       => 'fth1',
							'name'          => 'Page Title',
							'key'           => 'fndry-text-pageTitle',
							'color'         => 'var(--fndry-color-marianBlue)',
							'setAsDefault'  => true,
							'tag'           => 'h1',
							'family'        => 'var(--fndry-font-robotoMono)',
							'minFontSize'   => '3rem',
							'maxFontSize'   => '5rem',
							'line'          => 1.5,
							'spacing'       => '0rem',
							'weight'        => 500,
							'textUppercase' => false,
							'italic'        => false,
							'isResponsive'  => true,
						],
						[
							'fndryId'       => 'fth2',
							'name'          => 'Primary Headline',
							'key'           => 'fndry-text-primaryHeadline',
							'color'         => 'var(--fndry-color-marianBlue)',
							'setAsDefault'  => true,
							'tag'           => 'h2',
							'family'        => 'var(--fndry-font-roboto)',
							'minFontSize'   => '2rem',
							'maxFontSize'   => '4rem',
							'line'          => 1.5,
							'spacing'       => '0rem',
							'weight'        => 600,
							'textUppercase' => false,
							'italic'        => false,
							'isResponsive'  => true,
						],
						[
							'fndryId'       => 'fth3',
							'name'          => 'Label',
							'key'           => 'fndry-text-label',
							'color'         => 'var(--fndry-color-raspberry)',
							'setAsDefault'  => false,
							'family'        => 'var(--fndry-font-robotoMono)',
							'minFontSize'   => '0.875rem',
							'line'          => 1.25,
							'spacing'       => '0rem',
							'kern'          => '1px',
							'weight'        => 900,
							'textUppercase' => true,
							'italic'        => false,
							'isResponsive'  => false,
						],
					],
					// because letter-spacing isn't included in the font shorthand, these should probably just
					// be generated as text utility classes in the head.
					'textStyles'   => [
						[
							'fndryId'       => 'ftt1',
							'name'          => 'Intro Copy',
							'key'           => 'fndry-text-introCopy', // -> .fndry-text prefix for utility classes
							'color'         => 'var(--fndry-color-marianBlue)',
							'setAsDefault'  => true,
							'family'        => 'var(--fndry-font-robotoMono)',
							'minFontSize'   => '1.5rem',
							'isResponsive'  => false,
							'line'          => 1.5,
							'spacing'       => '0rem',
							'kern'          => '',
							'weight'        => 100,
							'textUppercase' => false,
							'italic'        => false,
						],
						[
							'fndryId'       => 'ftt2',
							'name'          => 'Legal',
							'key'           => 'fndry-text-legal',
							'color'         => 'var(--fndry-color-black)',
							'setAsDefault'  => false,
							'family'        => 'var(--fndry-font-robotoMono)',
							'minFontSize'   => '1rem',
							'line'          => 1.25,
							'spacing'       => '0rem',
							'kern'          => '',
							'weight'        => 600,
							'textUppercase' => false,
							'italic'        => false,
							'isResponsive'  => false,
						],
					],
				],
				'shadows'    => [
					'boxShadows' => [
						[
							'fndryId' => 'fbs1',
							'name'    => 'Standard',
							'key'     => '--fndry-bshadow-standard',
							'color'   => 'var(--fndry-color-black)',
							'x'       => '0',
							'y'       => '1em',
							'blur'    => '1em',
							'spread'  => '0',
							'inset'   => false,
						],
					],
				],
				'forms'      => [
					'labelStyle'           => 'fndry-text-legal',
					'textStyle'            => '', // empty means no style (i.e. use body cascade)
					'fieldBackgroundColor' => 'var(--fndry-color-white)',
					'strokeColor'          => 'var(--fndry-color-marianBlue)',
					'strokeWeight'         => '1px',
					'borderRadius'         => '1px',
					'buttonStyle'          => 'fndry-btn-primary',
				],
			],
			'show_in_rest'      => [
				'schema' => FoundrySchema::GLOBAL_STYLES,
			],
		]
	);

	register_setting(
		'foundry_plugin_settings_page',
		'fndry_custom_fields',
		[
			'type'              => 'object',
			'sanitize_callback' => [ Foundry::instance(), 'sanitizeSchema__CUSTOM_FIELDS' ],
			'show_in_rest'      => [
				'schema' => FoundrySchema::CUSTOM_FIELDS,
			],
		]
	);

	register_setting(
		'foundry_plugin_settings_page',
		'fndry_animation_settings',
		[
			'type'              => 'object',
			'sanitize_callback' => [ Foundry::instance(), 'sanitizeSchema__ANIMATION' ],
			'show_in_rest'      => [
				'schema' => FoundrySchema::ANIMATION,
			],
		]
	);

	register_setting(
		'foundry_plugin_settings_page',
		'fndry_general_settings',
		[
			'type'              => 'object',
			'sanitize_callback' => [ Foundry::instance(), 'sanitizeSchema__GENERAL' ],
			'default'           => [
				[
					'maps'        => [
						'googleMapsEnabled' => false,
						'mapsApiKey'        => '',
						'mapLocations'      => [
							[
								'fndryId' => 'fm1',
								'name'    => 'Main Location',
								'key'     => 'fndry-map-primary',
								'address' => '',
							],
						],
					],
					'gridSpacing' => [
						'gutter' => '1rem',
					],
				],
			],
			'show_in_rest'      => [
				'schema' => FoundrySchema::GENERAL,
			],
		]
	);
	register_setting(
		'foundry_plugin_settings_page',
		'fndry_component_styles',
		[
			'type'              => 'object',
			'sanitize_callback' => [ Foundry::instance(), 'sanitizeSchema__COMPONENT_STYLES' ],
			'default'           => [
				'defaultLinkStyle' => [
					'hasUnderline' => false,
				],
				'buttons'          => [
					'buttonStyles' => [
						[
							// splice out "button" from the name when generating key
							'fndryId'         => 'fb1',
							'key'             => 'fndry-btn-primary',
							'name'            => 'Primary Button',
							'backgroundColor' => 'var(--fndry-color-marianBlue)',
							'strokeColor'     => '', // if values are "0px", then save no value.
							'strokeWeight'    => '',
							'borderRadius'    => '',
							'btnPadding'      => [
								'top'    => '1em',
								'right'  => '0.5em',
								'bottom' => '1em',
								'left'   => '0.5em',
							],
							'fontFamily'      => 'var(--fndry-font-roboto)',
							'fontColor'       => 'var(--fndry-color-white)',
							'fontSize'        => '0.875rem',
							'kern'            => '',
							'fontWeight'      => 500,
							'textUppercase'   => true,
							'italic'          => false,
							'setAsDefault'    => true,
							'hasIcon'         => false,
							'icon'            => [
								'type'     => 'custom',
								'id'       => 0,
								'faSize'   => '20px',
								'position' => 'right',
								'padding'  => '15px',
								'color'    => '',
							],
							'hasBoxShadow'    => false,
							'boxShadow'       => [
								'x'      => '0',
								'y'      => '0.875rem',
								'blur'   => '1em',
								'spread' => '0',
								'color'  => 'var(--fndry-color-black)',
							],
							'hasUnderline'    => false,
							'padding'         => [
								'x' => '1em',
								'y' => '0.5em',
							],
						],
						[
							'fndryId'         => 'fb2',
							'key'             => 'fndry-btn-secondary',
							'name'            => 'Secondary Button',
							'backgroundColor' => 'var(--fndry-color-raspberry)',
							'strokeColor'     => '', // if values are "0px", then save no value.
							'strokeWeight'    => '',
							'borderRadius'    => '',
							'btnPadding'      => [
								'top'    => '1em',
								'right'  => '0.5em',
								'bottom' => '1em',
								'left'   => '0.5em',
							],
							'fontFamily'      => 'var(--fndry-font-roboto)',
							'fontColor'       => 'var(--fndry-color-white)',
							'fontSize'        => '0.875rem',
							'kern'            => '',
							'fontWeight'      => 500,
							'textUppercase'   => true,
							'italic'          => false,
							'setAsDefault'    => false,
							'hasIcon'         => false,
							'icon'            => [
								'type'     => 'custom',
								'id'       => 0,
								'faSize'   => '20px',
								'position' => 'right',
								'padding'  => '15px',
								'color'    => '',
							],
							'hasBoxShadow'    => false,
							'boxShadow'       => [
								'x'      => '0',
								'y'      => '0.875rem',
								'blur'   => '1em',
								'spread' => '0',
								'color'  => 'var(--fndry-color-black)',
							],
							'hasUnderline'    => false,
							'underline'       => [],
							'padding'         => [
								'x' => '1em',
								'y' => '0.5em',
							],
						],
					],
				],
			],
			'show_in_rest'      => [
				'schema' => FoundrySchema::COMPONENT_STYLES,
			],
		]
	);
}

add_action( 'init', 'foundry_plugin_register_settings', 1 );
add_action( 'rest_api_init', 'foundry_plugin_register_settings', 1 );

/**
 * Enqueue our scripts for our plugin
 */


if ( ! function_exists( 'foundry_enqueue_scripts' ) ):
	/**
	 * Checks if a block styles/scripts should be enqueued.
	 *
	 * @param   string  $hook  - Options page hook.
	 */

	global $pagenow;

	if ( $pagenow !== 'admin.php' ) {
		return null;
	}

	function foundry_enqueue_scripts( $hook ) {
		/**
		 * We need to enqueue `wp-edit-post` and `jquery`
		 * so they are loaded into the DOM
		 */

		$script_handle = 'foundry-script';

		$script_path = REFOUNDRY_ENQUEUE_URL . '/dist/js/fndry.globalSettings.build.js';

		$deps = [
			'lodash',
			'wp-block-editor',
			'wp-block-library',
			'wp-plugins',
			'wp-blocks',
			'wp-components',
			'wp-data',
			'wp-dom-ready',
			'wp-editor',
			'wp-element',
			'wp-format-library',
			'wp-i18n',
			'wp-keyboard-shortcuts',
			'wp-media-utils',
			'wp-polyfill',
			'wp-block-library',
			'wp-blocks',
			'wp-element',
			'wp-edit-post',
			'jquery',
		];

		wp_enqueue_script( $script_handle, $script_path, $deps, REFOUNDRY_PLUGIN_VERSION, [ 'in_footer' => true ] );

		wp_localize_script(
			'foundry-script',
			'foundry_globals',
			[
				// 'ajax_url' => admin_url( 'admin-ajax.php' ),
				'nonce'    => wp_create_nonce( 'wp_rest' ),
				'action'   => 'foundry_save_settings',
				'settings' => get_option( 'foundry_settings' ),
				'site_url' => get_rest_url(),
			]
		);

		// Editor default styles
		wp_enqueue_style( 'wp-format-library' );

		// Styles
		wp_enqueue_style(
			'fndry-settings',
			REFOUNDRY_ENQUEUE_URL . '/dist/css/fndry.globalSettings.build.css',
			[ 'wp-edit-blocks' ],
			REFOUNDRY_PLUGIN_VERSION
		);

		// version IS null; see https://core.trac.wordpress.org/ticket/49742
		wp_enqueue_style(
			'foundry-google-font',
			'https://fonts.googleapis.com/css2?family=Roboto:wght@100;400;500;700&display=swap',
			[],
			null // phpcs:ignore   WordPress.WP.EnqueuedResourceParameters.MissingVersion
		);
	}

	add_action( 'admin_enqueue_scripts', 'foundry_enqueue_scripts' );
endif;