<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
// setup instance and initialize block registration
function fndry_enqueue_block_editor_assets() {
	$block_path = 'dist/js/fndry.editor.build.js';
	$style_path = 'dist/css/fndry.editor.build.css';

	// Enqueue the bundled block JS file.
	wp_enqueue_script(
		'fndry-editor-js',
		REFOUNDRY_ENQUEUE_URL . $block_path,
		[
			'lodash',
			'wp-block-editor',
			'wp-block-library',
			'wp-plugins',
			'wp-blocks',
			'wp-components',
			'wp-data',
			'wp-dom-ready',
			'wp-editor',
			'wp-element',
			'wp-format-library',
			'wp-i18n',
			'wp-keyboard-shortcuts',
			'wp-media-utils',
			'wp-polyfill',
			'wp-block-library',
			'wp-blocks',
			'wp-element',
			'wp-edit-post',
			'jquery',
		],
		REFOUNDRY_PLUGIN_VERSION,
		true
	);

	// Enqueue optional editor only styles.
	wp_enqueue_style(
		'fndry-editor-style',
		REFOUNDRY_ENQUEUE_URL . $style_path,
		[],
		REFOUNDRY_PLUGIN_VERSION
	);
}

add_action( 'enqueue_block_editor_assets', 'fndry_enqueue_block_editor_assets' );

function fndry_enqueue_assets() {
	$style_path = 'dist/css/fndry.style.build.css';
	wp_enqueue_style(
		'fndry-style',
		REFOUNDRY_ENQUEUE_URL . $style_path,
		null,
		REFOUNDRY_PLUGIN_VERSION
	);
}

add_action( 'enqueue_block_assets', 'fndry_enqueue_assets' );

/**
 * Enqueue frontend JavaScript and CSS assets.
 */
function fndry_enqueue_frontend_assets() {
	// If in the backend, bail out.
	if ( is_admin() ) {
		return;
	}

	$block_path = '/dist/js/fndry.frontend.build.js';
	wp_enqueue_script(
		'fndry-frontend',
		REFOUNDRY_ENQUEUE_URL . $block_path,
		[],
		REFOUNDRY_PLUGIN_VERSION,
		true
	);
}

add_action( 'enqueue_block_assets', 'fndry_enqueue_frontend_assets' );

function openInNewTab() {
	if ( ! defined( 'REFOUNDRY_PRO_DIR' ) ) {
	?>
		<script type="text/javascript">
			document.addEventListener("DOMContentLoaded", () => {
				document.querySelector("a[href='https://refoundry.io/pricing']")?.setAttribute("target", "_blank")
			});
		</script>
	<?php
	}
}

add_action( 'admin_head', 'openInNewTab' );