<?php

namespace ForgeSmith;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
final class FoundrySchema {

	const COMPONENT_STYLES = [
		'type'       => 'object',
		'properties' => [
			'defaultLinkStyle' => [
				'type'       => 'object',
				'properties' => [
					'color'        => [
						'type' => 'string',
					],
					'fontFamily'   => [
						'type' => 'string',
					],
					'hoverColor'   => [
						'type' => 'string',
					],
					'activeColor'  => [
						'type' => 'string',
					],
					'visitedColor' => [
						'type' => 'string',
					],
					'hasUnderline' => [
						'type' => 'boolean',
					],
					'underline'    => [
						'type'       => 'object',
						'properties' => [
							'strokeColor'        => [
								'type' => 'string',
							],
							'strokeHoverColor'   => [
								'type' => 'string',
							],
							'strokeWeight'       => [
								'type' => 'string',
							],
							'offset'             => [
								'type' => 'string',
							],
							'underlineAnimation' => [
								'type' => 'boolean',
							],
						],
					],
				],
			],
			'buttons'          => [
				'type'       => 'object',
				'properties' => [
					'transitionDuration'             => [
						'type' => 'number',
					],
					'transitionDelay'                => [
						'type' => 'number',
					],
					'transitionTimingFunction'       => [
						'type' => 'string',
					],
					'customTransitionTimingFunction' => [
						'type' => 'string',
					],
					'buttonStyles'                   => [
						'type'  => 'array',
						'items' => [
							'type'       => 'object',
							'properties' => [
								'fndryId'         => [
									'type' => 'string',
								],
								'key'             => [
									'type' => 'string',
								],
								'name'            => [
									'type' => 'string',
								],
								'backgroundColor' => [
									'type' => 'string',
								],
								'strokeColor'     => [
									'type' => 'string',
								],
								'strokeWeight'    => [
									'type' => 'string',
								],
								'borderRadius'    => [
									'type' => 'string',
								],
								'btnPadding'      => [
									'type'       => 'object',
									'properties' => [
										'top'    => [
											'type' => 'string',
										],
										'right'  => [
											'type' => 'string',
										],
										'bottom' => [
											'type' => 'string',
										],
										'left'   => [
											'type' => 'string',
										],
									],
								],
								'fontFamily'      => [
									'type' => 'string',
								],
								'fontColor'       => [
									'type' => 'string',
								],
								'fontSize'        => [
									'type' => 'string',
								],
								'kern'            => [
									'type' => 'string',
								],
								'fontWeight'      => [
									'type' => 'number',
								],
								'setAsDefault'    => [
									'type' => 'boolean',
								],
								'textUppercase'   => [
									'type' => 'boolean',
								],
								'italic'          => [
									'type' => 'boolean',
								],
								'hasIcon'         => [
									'type' => 'boolean',
								],
								'icon'            => [
									'type'       => 'object',
									'properties' => [
										'type'     => [
											'type' => 'string',
										],
										'faId'     => [
											'type' => 'string',
										],
										'faPrefix' => [
											'type' => 'string',
										],
										'position' => [
											'type' => 'string',
										],
										'gap'      => [
											'type' => 'string',
										],
										'size'     => [
											'type' => 'string',
										],
										'faSize'   => [
											'type' => 'string',
										],
										'color'    => [
											'type' => 'string',
										],
										// if not FA, use mediaupload.
										// only size, position and padding will be shown
										'id'       => [
											'type' => 'number',
										],
									],
								],
								'hasBoxShadow'    => [
									'type' => 'boolean',
								],
								'boxShadow'       => [
									'type' => 'string',
								],
								'hasUnderline'    => [
									'type' => 'boolean',
								],
								'underline'       => [
									'type'       => 'object',
									'properties' => [
										'strokeColor'        => [
											'type' => 'string',
										],
										'strokeWeight'       => [
											'type' => 'string',
										],
										'offset'             => [
											'type' => 'string',
										],
										'underlineAnimation' => [
											'type' => 'boolean',
										],
									],
								],
								// let em use EM if they wanna.
								'padding'         => [
									'type'       => 'object',
									'properties' => [
										'x' => [
											'type' => 'string',
										],
										'y' => [
											'type' => 'string',
										],
									],
								],
								'transitions'     => [
									'type'  => 'array',
									'items' => [
										'type'       => 'object',
										'properties' => [
											'fndryId'                        => [
												'type' => 'string',
											],
											'transitionProperties'           => [
												'type'  => 'array',
												'items' => [
													'type' => 'string',
												],
											],
											'transitionDuration'             => [
												'type' => 'number',
											],
											'transitionDelay'                => [
												'type' => 'number',
											],
											'transitionTimingFunction'       => [
												'type' => 'string',
											],
											'customTransitionTimingFunction' => [
												'type' => 'string',
											],
										],
									],
								],
								'hoverStyle'      => [
									'type'       => 'object',
									'properties' => [
										'transitions'     => [
											'type'  => 'array',
											'items' => [
												'type'       => 'object',
												'properties' => [
													'fndryId'                        => [
														'type' => 'string',
													],
													'transitionProperties'           => [
														'type'  => 'array',
														'items' => [
															'type' => 'string',
														],
													],
													'transitionDuration'             => [
														'type' => 'number',
													],
													'transitionDelay'                => [
														'type' => 'number',
													],
													'transitionTimingFunction'       => [
														'type' => 'string',
													],
													'customTransitionTimingFunction' => [
														'type' => 'string',
													],
												],
											],
										],
										'backgroundColor' => [
											'type' => 'string',
										],
										'fontColor'       => [
											'type' => 'string',
										],
										'iconColor'       => [
											'type' => 'string',
										],
										'strokeColor'     => [
											'type' => 'string',
										],
										'strokeWeight'    => [
											'type' => 'string',
										],
										'borderRadius'    => [
											'type' => 'string',
										],
										'boxShadow'       => [
											'type' => 'string',
										],
										'btnPadding'      => [
											'type'       => 'object',
											'properties' => [
												'top'    => [
													'type' => 'string',
												],
												'right'  => [
													'type' => 'string',
												],
												'bottom' => [
													'type' => 'string',
												],
												'left'   => [
													'type' => 'string',
												],
											],
										],
										'underline'       => [
											'type'       => 'object',
											'properties' => [
												'strokeColor'        => [
													'type' => 'string',
												],
												'strokeWeight'       => [
													'type' => 'string',
												],
												'offset'             => [
													'type' => 'string',
												],
												'underlineAnimation' => [
													'type' => 'boolean',
												],
											],
										],
									],
								],
							],
						],
					],
				],
			],
		],
	];

	const GENERAL = [
		'type'       => 'object',
		'properties' => [
			'gridSettings' => [
				'type'       => 'object',
				'properties' => [
					'gutter' => [
						'type' => 'string',
					],
				],
			],
			'googleMaps'   => [
				'type'       => 'object',
				'properties' => [
					'googleMapsEnabled' => [
						'type' => 'boolean',
					],
					'mapsApiKey'        => [
						'type' => 'string',
					],
					'mapLocations'      => [
						'type'  => 'array',
						'items' => [
							'type'       => 'object',
							'properties' => [
								'fndryId'    => [
									'type' => 'string',
								],
								'name'       => [
									'type' => 'string',
								],
								'key'        => [
									'type' => 'string',
								],
								'address'    => [
									'type' => 'string',
								],
								'position'   => [
									'type'       => 'object',
									'properties' => [
										'lat' => [
											'type' => 'number',
										],
										'lng' => [
											'type' => 'number',
										],
									],
								],
								'marker'     => [
									'type' => 'number',
								],
								'infoWindow' => [
									'type'       => 'object',
									'properties' => [
										'title'     => [
											'type' => 'string',
										],
										'content'   => [
											'type' => 'string',
										],
										'link'      => [
											'type'       => 'object',
											'properties' => [
												'title'  => [
													'type' => 'string',
												],
												'url'    => [
													'type' => 'string',
												],
												'newTab' => [
													'type' => 'boolean',
												],
											],
										],
										// todo - add linkstyle support.
										'linkStyle' => [
											'type' => 'string',
										],
									],
								],
							],
						],
					],

				],
			],
		],
	];
	const ANIMATION = [
		'type'       => 'object',
		'properties' => [
			'parallax' => [
				'type'       => 'object',
				'properties' => [
					'parallaxEnabled' => [
						'type' => 'boolean',
					],
				],
			],
		],
	];
	const CUSTOM_FIELDS = [
		'type'       => 'object',
		'properties' => [
			'manageCustomFields' => [
				'type'       => 'object',
				'properties' => [
					'customFields' => [
						'type'  => 'array',
						'items' => [
							'type'       => 'object',
							'properties' => [
								'fndryId'  => [
									'type' => 'string',
								],
								'label'    => [
									'type' => 'string',
								],
								'slug'     => [
									'type' => 'string',
								],
								'postType' => [
									'type' => 'array',
								],
							],
						],
					],
				],
			],
		],
	];
	const GLOBAL_STYLES = [
		'type'       => 'object',
		'properties' => [
			'colors'     => [
				'type'       => 'object',
				'properties' => [
					'primary'   => [
						'type'  => 'array',
						'items' => [
							'type'       => 'object',
							'properties' => [
								'fndryId' => [
									'type' => 'string',
								],
								'key'     => [
									'type' => 'string',
								],
								'hex'     => [
									'type' => 'string',
								],
								'name'    => [
									'type' => 'string',
								],
							],
						],
					],
					'secondary' => [
						'type'  => 'array',
						'items' => [
							'type'       => 'object',
							'properties' => [
								'fndryId' => [
									'type' => 'string',
								],
								'key'     => [
									'type' => 'string',
								],
								'hex'     => [
									'type' => 'string',
								],
								'name'    => [
									'type' => 'string',
								],
							],
						],
					],
					'neutral'   => [
						'type'  => 'array',
						'items' => [
							'type'       => 'object',
							'properties' => [
								'fndryId' => [
									'type' => 'string',
								],
								'key'     => [
									'type' => 'string',
								],
								'hex'     => [
									'type' => 'string',
								],
								'name'    => [
									'type' => 'string',
								],
							],
						],
					],
				],
			],
			'fonts'      => [
				'type'       => 'object',
				'properties' => [
					'adobeFontsEnabled'      => [
						'type' => 'boolean',
					],
					'adobeFontsProjectId'    => [
						'type' => 'string',
					],
					'adobeFontsApiKey'       => [
						'type' => 'string',
					],
					'googleFontsEnabled'     => [
						'type' => 'boolean',
					],
					'googleFontsImportValue' => [
						'type'  => 'array',
						'items' => [
							'type'       => 'object',
							'properties' => [
								'family'   => [
									'type' => 'string',
								],
								'import'   => [
									'type' => 'string',
								],
								'fallback' => [
									'type' => 'string',
								],
								'fndryId'  => [
									'type' => 'string',
								],
							],
						],
					],
					'adobeFontsImportValue'  => [
						'type'  => 'array',
						'items' => [
							'type'       => 'object',
							'properties' => [
								'family'    => [
									'type' => 'string',
								],
								'css_stack' => [
									'type' => 'string',
								],
								'variations' => [
									'type' => 'array',
								],
							],
						],
					],
					'fontAwesomeEnabled'     => [
						'type' => 'boolean',
					],
					'fontAwesomeKitName'     => [
						'type' => 'string',
					],
				],
			],
			'typography' => [
				'type'       => 'object',
				'properties' => [
					'bodyStyle'    => [
						'type'       => 'object',
						'properties' => [
							'color'        => [
								'type' => 'string',
							],
							'family'       => [
								'type' => 'string',
							],
							'minFontSize'  => [
								'type' => 'string',
							],
							'maxFontSize'  => [
								'type' => 'string',
							],
							'line'         => [
								'type' => 'number',
							],
							'spacing'      => [
								'type' => 'string',
							],
							'kern'         => [
								'type' => 'string',
							],
							'weight'       => [
								'type' => 'number',
							],
							'isResponsive' => [
								'type' => 'boolean',
							],
						],
					],
					'headerStyles' => [
						'type'  => 'array',
						'items' => [
							'type'       => 'object',
							'properties' => [
								'fndryId'                 => [
									'type' => 'string',
								],
								'name'                    => [
									'type' => 'string',
								],
								'key'                     => [
									'type' => 'string',
								],
								'color'                   => [
									'type' => 'string',
								],
								'setAsDefault'            => [
									'type' => 'boolean',
								],
								'tag'                     => [
									'type' => 'string',
								],
								'family'                  => [
									'type' => 'string',
								],
								'minFontSize'             => [
									'type' => 'string',
								],
								'maxFontSize'             => [
									'type' => 'string',
								],
								'line'                    => [
									'type' => 'number',
								],
								'spacing'                 => [
									'type' => 'string',
								],
								'kern'                    => [
									'type' => 'string',
								],
								'weight'                  => [
									'type' => 'number',
								],
								'textUppercase'           => [
									'type' => 'boolean',
								],
								'italic'                  => [
									'type' => 'boolean',
								],
								'isResponsive'            => [
									'type' => 'boolean',
								],
								'linkColor'               => [
									'type' => 'string',
								],
								'linkHoverColor'          => [
									'type' => 'string',
								],
								'linkUnderline'           => [
									'type' => 'boolean',
								],
								'linkUnderlineWidth'      => [
									'type' => 'string',
								],
								'linkUnderlineColor'      => [
									'type' => 'string',
								],
								'linkHoverUnderlineColor' => [
									'type' => 'string',
								],
								'linkUnderlineAnimation'  => [
									'type' => 'boolean',
								],
							],
						],
					],

					'textStyles' => [
						'type'  => 'array',
						'items' => [
							'type'       => 'object',
							'properties' => [
								'fndryId'                 => [
									'type' => 'string',
								],
								'name'                    => [
									'type' => 'string',
								],
								'key'                     => [
									'type' => 'string',
								],
								'color'                   => [
									'type' => 'string',
								],
								'setAsDefault'            => [
									'type' => 'boolean',
								],
								'family'                  => [
									'type' => 'string',
								],
								'minFontSize'             => [
									'type' => 'string',
								],
								'maxFontSize'             => [
									'type' => 'string',
								],
								'line'                    => [
									'type' => 'number',
								],
								'spacing'                 => [
									'type' => 'string',
								],
								'kern'                    => [
									'type' => 'string',
								],
								'weight'                  => [
									'type' => 'number',
								],
								'textUppercase'           => [
									'type' => 'boolean',
								],
								'italic'                  => [
									'type' => 'boolean',
								],
								'isResponsive'            => [
									'type' => 'boolean',
								],
								'linkColor'               => [
									'type' => 'string',
								],
								'linkHoverColor'          => [
									'type' => 'string',
								],
								'linkUnderline'           => [
									'type' => 'boolean',
								],
								'linkUnderlineWidth'      => [
									'type' => 'string',
								],
								'linkUnderlineColor'      => [
									'type' => 'string',
								],
								'linkHoverUnderlineColor' => [
									'type' => 'string',
								],
								'linkUnderlineAnimation'  => [
									'type' => 'boolean',
								],
							],
						],
					],
				],
			],
			'shadows'    => [
				'type'       => 'object',
				'properties' => [
					'boxShadows' => [
						'type'  => 'array',
						'items' => [
							'type'       => 'object',
							'properties' => [
								'fndryId' => [
									'type' => 'string',
								],
								'name'    => [
									'type' => 'string',
								],
								'key'     => [
									'type' => 'string',
								],
								'color'   => [
									'type' => 'string',
								],
								'x'       => [
									'type' => 'string',
								],
								'y'       => [
									'type' => 'string',
								],
								'blur'    => [
									'type' => 'string',
								],
								'spread'  => [
									'type' => 'string',
								],
								'inset'   => [
									'type' => 'boolean',
								],
							],
						],
					],
				],
			],
			'forms'      => [
				'type'       => 'object',
				'properties' => [
					'labelStyle'           => [
						'type' => 'string',
					],
					'textStyle'            => [
						'type' => 'string',
					],
					'fieldBackgroundColor' => [
						'type' => 'string',
					],
					'strokeColor'          => [
						'type' => 'string',
					],
					'strokeWeight'         => [
						'type' => 'string',
					],
					'borderRadius'         => [
						'type' => 'string',
					],
					'buttonStyle'          => [
						'type' => 'string',
					],
				],
			],
		],
	];
}