=== Refoundry Blocks ===
Contributors: forgesmith, barryrumack, trjwaugh, vbertoletti
Tags: gutenberg, blocks
Tested up to: 6.8
Stable tag: 1.10.5
License: GPLv2 or later
License URI: https://www.gnu.org/licenses/gpl-2.0.html

A low-code, themeless visual site builder that enhances Gutenberg. Get faster page speeds, responsive blocks, and total creative control. Try it now!

== Description ==

**Love WordPress but hate themes? Want granular control over every single element of your sites, without moving to a proprietary site builder platform to get it? Refoundry is for you.**

Refoundry is a low-code, theme-free visual site builder that enhances Gutenberg. Get faster page speeds, responsive blocks, and total creative control.

Try it now for free! Or unlock Refoundry’s most exciting features, engineered for agencies, with [Refoundry Pro](https://refoundry.io/pricing/).

### Build High-Performing Custom Websites, Faster

Your clients want control over every little detail of their new sites without having to hire a developer. You want to increase profitability. Refoundry is a win/win.

* Save 70-80% on development time by building the majority of your sites with Refoundry’s responsive [blocks](https://refoundry.io/support/the-blocks/)
* Only 10-20% of the build requires coding, leaving your developers more time for fun stuff like interactions and customizations with CSS, JavaScript, JSON API integrations, or functions.php
* Refoundry drastically reduces or even eliminates the hours wasted on bug fixes
* Anyone on the team can make edits to content, layouts, and styling – no waiting in a queue for developers
* Pro users can combine [Reusable Component Blocks](https://refoundry.io/the-blocks/reusable-component-block/) and the [Component Library](https://refoundry.io/features/component-library/) of responsive layouts to build new pages in record time

Need to know more? [Compare Refoundry](https://refoundry.io/compare/) to other site builders, and learn more about the [benefits to agencies](https://refoundry.io/agencies/) already using Refoundry. Or check the FAQs on this page!

### The Blocks

All Refoundry users get access to the entire library of responsive blocks. These are like the default WordPress blocks, except better – and you have total control over style and layout settings in the visual editor.

* Accordion
* Advanced Filters
* Archive List
* Button
* Column
* Container
* Featured Image
* Filter Dropdown
* Filter Search Bar
* Filters (parent)
* Google Maps
* Grid
* Heading
* Image
* List
* Logo Grid
* Navigation
* Next Page
* No Results
* Page Numbers
* Pagination
* Paragraph
* Post Author
* Post Date
* Post Excerpt
* Post Terms
* Post Title
* Previous Page
* Query Block
* Query Post Template
* Related Posts
* Reusable Component Block
* Row
* Slideout
* Slider (carousel)
* Social Icons
* Tabs (navigation)
* Video Popup

### The Settings
We keep talking about how you can control all of the settings in the editor, and they’re not locked into the theme or hard-coded into the page template. These are Refoundry’s settings and features.

* Adobe Font Kits
* Borders & Radius
* Box Shadow
* Button & Link Styles
* Color Codes
* Colors
* Custom Fields
* Display Settings
* Font Awesome Shortcodes
* Global Styles
* Google Fonts
* Google Maps
* Gradient Backgrounds
* Gutter
* HTML Anchor
* Image Background
* Parallax
* Positioning
* Responsive Block Settings
* Spacing
* Sticky Header
* Theme Customizations
* Typography
* Utility Classes
* Widths

Refoundry **enhances the Gutenberg editor**, so all of the regular WordPress settings and features you’d expect are also present, like the list view, user roles, toolbar menus, templates, template parts, patterns, and responsive previews.

### Pro Features

* **[Reusable Component Blocks:](https://refoundry.io/the-blocks/reusable-component-block/)** Save any group of Refoundry blocks – even whole page layouts – as reusable components. Add them anywhere in a couple of clicks. Edit globally or edit local instances.
* **Custom Fields**: Add extra custom data to your posts or pages, beyond the standard fields for content that you can build with regular Refoundry blocks (or with the Component Library sections that are also available to Pro users).
* **[Component Library](https://refoundry.io/features/component-library/)**: A library of 72+ professionally designed, fully responsive component layouts that you can drop into your pages, or fetch with ScoutAI. They include banners, text sections, callouts, grids, and post loops.
* **Animations and Parallax:** Add movement and drive engagement with scroll parallax effects, smooth scrolling, in-page scroll, sticky elements, head’s up, hover styles, and support for animate file formats.

### Support

Refoundry has a team of real humans with decades of agency experience (including product engineering to design, development, SEO, content, project management, and digital strategy) working behind the scenes. We want Refoundry to be the solution that makes your builds better, faster, and more successful.

We deliver quick turnarounds on support requests. Pro users get priority email support. We also have a thorough (and free) [Support Library](https://refoundry.io/support/) that includes detailed documentation on every single [block](https://refoundry.io/support/the-blocks/), [settings and features](https://refoundry.io/support/settings-features/), and [video tutorials](https://refoundry.io/support/how-to-tutorials/).

== Frequently Asked Questions ==

= Is Refoundry legitimate? Are there live Refoundry websites I can see? =

Yes! Refoundry has been used to create professional, high-performance websites since late 2022. There are hundreds of early Refoundry users out there in the wild, including agencies, site owners, marketers, and technical teams.

Refoundry’s case studies library is coming soon! In the meantime, you can see a selection of websites built entirely using Refoundry on the [Forge and Smith](https://forgeandsmith.com/industries/built-with-refoundry/) website (we’re the agency behind Refoundry).

= What’s included in the Pro version of Refoundry? =

The Pro version includes everything from the free version, plus advanced features like the Component Library, animations & parallax, custom fields and Reusable Component Blocks. It’s perfect for more complex or dynamic websites. Read more on our [Pro Features](https://refoundry.io/features/pro-features/).

= Can I try the Pro version before purchasing? =

We don’t offer a trial of the Pro version, but you can start with the free version to see how Refoundry works. If you find that you need the additional features, upgrading to Pro is quick and easy. We also offer custom demos to help you decide if Refoundry is right for you, and we offer a refund if, after 30 days, you don’t love Refoundry.

= Does purchasing Pro include support? =

Yes, purchasing the Pro version gives you access to priority email support. We’re here to help with any questions or issues you might encounter while building with Refoundry. For a limited time to support our early adopters, we’re able to offer screenshares to help get you up to speed even faster.

= How do I install Refoundry? =

Download the Refoundry zip file you received in your email. In your WordPress admin dashboard, navigate to Plugins > Add New. Click “Upload Plugin”, select the downloaded zip file, and click “Install Now.”

After installation, be sure to activate the plugin to enable its features. Read more in our support documentation.

= What is Refoundry’s compatibility? =

Refoundry was engineered to enhance the Gutenberg editor, so anything Gutenberg can do, Refoundry can do too (and better!). If a plugin is compatible with Gutenberg, it should also work with Refoundry. That means you can keep using all of your favourite plugins for SEO, accessibility, translation, analytics, form-building, reviews, security, and so on.

The same is true of any tech integration, such as eCommerce platforms and marketing platforms. You do need to have PHP 8.0 or higher, and WordPress version 6.6 or higher.

= Can I add Refoundry to my existing WordPress site? =

Yes! You can add Refoundry to any WordPress site that uses the Gutenberg editor.

= Can I use regular WordPress blocks on a Refoundry site? =

Yes, and they will even pick up the Global Styles settings that you’ve created for Refoundry.

= Do I need to be a developer to use Refoundry? =

No. Refoundry is a low-code tool that renders code as you work with the blocks and native settings. Anyone can use it to create layouts, build menus, make templates, set global styles, and more. With that said, you’ll have an easier time getting started with Refoundry if you’re already comfortable with the Gutenberg full site editor and the concept of containers, rows, and columns.

= Does Refoundry have a theme? =

Refoundry is themeless in the traditional sense, where a theme is a bunch of code that controls creative elements across your site. Refoundry comes with two themes that don’t do anything like that. One is empty, and only exists so that Refoundry can work with WordPress, and to give developers a place to add custom code. The other is Refoundry’s Starter Theme, which is optional to use and comes with global and component style presets as well as a basic header, footer, and a demo page to help you get started faster.

= Does Refoundry use templates? =

You don’t have to use templates to build with Refoundry. But Refoundry can work with templates in the same way any WordPress site can (ie. with the default templates and templates parts functions, which you can build out with Refoundry blocks), because templates make it easier and faster to create new content!

Pro users also have access to a library of expert-crafted, responsive UX templates, from small content sections to entire layouts. You can make as many custom layouts as you want, and even customize styles and layout settings within a template.

= Can I customize Refoundry? =

Absolutely. Just because it’s low-code, doesn’t mean you’re limited. WordPress is open source, and Refoundry is an extension of WordPress. So developers can add custom CSS, JavaScript, or add functions to functions.php to build custom features, integrate tools, or modify WordPress behaviors — all while leveraging Refoundry’s flexible block-based system. It’s also easier to customize WordPress with Refoundry, because you can do this in the Custom Styles area of the full site editor as well as in the theme.

= Can I build a big website with Refoundry? =

Yes. Just like any other WordPress site, you can create as many pages and posts as you need. In fact, Refoundry makes it quicker to build page and post templates if you use its Reusable Component Blocks. We have seen Refoundry sites with 1k to 50k posts!

= Does Refoundry have good tech support? =

Refoundry was created by an agency, for agencies, and continues to be supported (and expanded) by its original team of experienced engineers. We know that any problem can eat into profitability. We have a team of real humans who answer all support requests. Pro users get priority email support. We also have a thorough (and free) Support Library that includes detailed documentation on every single block, settings and features, and video tutorials.

= Do you offer refunds? =

If you’re not 100% satisfied with Refoundry Pro we will refund your purchase.

== External Services ==

This plugin connects to Typekit (typekit.com) if provided a valid project ID and api key. An API key and Project ID are transmitted, receiving data from Typekit in the form of fonts to use. Fonts are used in the display of text on the site, if configured to do so.
This plugin connects to Google Maps API (maps.googleapis.com) if provided a valid API key. Only an API key is transmitted. This service is provided by Google.

== Changelog ==
= 1.10.5 =
* Fix issue with disappearing block toolbar for default paragraph blocks;

= 1.10.4 =
* Address issue where navigating to a post from its edit view could sometimes fail to render anything;

= 1.10.3 =
* Improve editor performance when saving a page containing many, many RCBs.
* Fix video popup buttons sometimes failing to prevent default click events when Tag Manager or other clicktracking scripts were present;
* Added source size controls for Image and Featured Image blocks;
* Fix duplicated "Transform to RCB" buttons when inside a Query block;
* Query block now has a meta key orderby option;
* Fix issue with being unable to save changes when changing the default body colour in global settings area;
* Fix editor with blocks using background layers inside an RCB would sometimes crash out if the number of layers was different in usage than it was in the original RCB;

= 1.10.2 =
* Fix issues with query block orderby parameters;
* Fix post type detection issues for query and related post blocks when editing a template in the site editor;

= 1.10.1 = 
* Fix extremely rare issue where selecting a post's featured image could sometimes cause the editor to crash;

= 1.10.0 =
* NEW: Slider Block Version 2! Brand-new slider block with its individual parts "atomized", so you can have even greater control on layouts. Also comes with a Query-based version!
* Post Date block now has margin override;
* Post Featured Image now has URL override;
* Excerpt block now applies its character limit to manually-generated excerpts in addition to automated ones;
* Added heading level controls to Accordion Block;
* Added additional padding to Navigation Submenu toggles for accessibility;
* More styling controls for the Slideout Block, with emphasis on hover/active states;
* Buttons can now be added to the Mixed Content Block;
* Social List Block now has style controls for hover states;
* Slider blocks with the "autoHeight" setting enabled now trigger it on window resize events too;
* Added custom CSS classname support for navigation submenu and tab blocks;
* Updated Paragraph block's content-entry behaviour to feel more fluid;
* Query Block now allows "Page" as a post type;
* Fixed Image Block's focal point handling of 0% positions;
* Fixed issues with RCBs sometimes including "default" blocks inside Mixed Content Blocks if the user had edited them to have less inner blocks than there were initially;
* Changed Block permission check to no longer use a placeholder spinner until the check was finished, check now no longer prevents block rendering;
* Fixed uncommon issue for button block in Safari not showing a text input caret when selected;
* Related Posts block: fixed "infinite" post handling;

= 1.9.10 =
* Fix some minor PHP deprecation warnings & compatibility issues;
* AppendableInnerBlocks gets a minor performance boost;
* Fixed issue with TabsBlocks inside RCBs sometimes reverting to their initial or default inner blocks;
* Fix various issues with "transform to RCB" button;
* An invalid or missing license key no longer causes RCBs to disappear. Instead, you just can't create new ones;
* A little spring-cleaning for our favourite statistics block;
* Fix nav block not saving hover & active link styles properly;
* Fix advanced filter block rendering incorrect markup for collapsible, hierarchical input groups;
* Fix rare compat issue with WooCommerce product images not saving sometimes;
* Added image caption positioning controls;
* Related Posts Block now has an option to not backfill with most recent posts in case no actual matches could be found;
* Fix some CSS filter issues on image blocks in the editor;

= 1.9.9 =
* Fix Post Featured Image sometimes not using height dimension correctly in the block editor;
* Removed yoast integration's "updating" notifications - we get it, you're updating the analysis, big whoop;
* Fix issue with RCBs detach action sometimes not having all of the user's changes present in the resulting list of blocks;
* Fix issue with RCBs and parent -> child blocks (introduced in 1.9.5) sometimes detaching and pasting without any of the child blocks that might have been added by the user;
* Improved performance of parent -> child blocks in RCBs;

= 1.9.8 =
* Fixed an issue where the Accordion label was sometimes misaligned;

= 1.9.7 =
* Fixed some image height issues relating to responsive height attributes;
* Fixed some editor behaviour for Post Featured Image;

= 1.9.6 =
* Fixed Logo Grid Block height issues;

= 1.9.5 = 
* Accordion block overhaul! Now with more layout & styling controls;
* Added flex and gap controls to List block;
* Global "gutter" controls added;
* Added ability for blocks with direct parent -> child relationships to allow adding and removing blocks while in an RCB (normally, blocks in RCBs are locked in). You can add and remove child blocks for Accordion, List, Grid, Logo, Slider, Slideout, Tab;
* Backgrounds for certain blocks are now responsive;
* You can now set image blocks to not output an alt prop - if you do, it will instead receive aria-hidden for accessibility purposes;
* Image blocks now also have responsive height, and can optionally display a caption;
* Added a Yoast integration so that it can properly account for Foundry blocks in its analysis panel inside the block editor;
* You can now adjust the positioning of the Navigation block's mobile menu overlay and said overlay's close button;
* Navigation block receives some performance improvements in the block editor;
* Added bluesky and pinterest as social share options;
* Fixed bug with Button block not allowing "use post link" option when inside a Related Posts block;
* Fixed bug with some font names being improperly cased when converted to a css variable, preventing them from being used in the front end;
* Slider block now has a gap option. It also now has a "bound" option;
* Tabs block now has border controls, and has an alternate vertical layout mode;
* Font weight options in Foundry Settings now correspond to the weights imported with the font families;
* logo grid block now has a min-height control and supports 5 column layouts;
* added a fix for images generated by wordpress functions being blurry in chrome - this affects ALL usages, not just ours;
* Renamed the "Component Styles" section in the settings area because it was a little confusing with Reusable Component Blocks being a thing. It's called Button Styles now!
* Address issues of inline svgs being stripped out of block content - FontAwesome's plugin recently changed from using shortcodes to just inserting the SVGs directly, and this meant it suddenly seemed to not work. Note that we're still very strict on what svg-related tags are allowed through;

= 1.9.4 =
* Fix statistics block in general - sorry lil bud;
* fix some function deprecations;
* Fix mixed content block list items sometimes erroring in the block editor;
* Fix frontend navigation overlay sometimes getting its content covered up by iOS address bar;
* Fix RCB detach function not detaching an up-to-date set of blocks sometimes;
* Fix uppercase behaviour in navigation styling;
* Fix accordion block's hash handling;
* Fix editor bug introduced by 6.8 incompatibility;


= 1.9.3 =
* Fix related posts block sometimes returning a smaller list of related posts on the front end;

= 1.9.2 =
* Fix Slideout block headings and subheadings sometimes not using colours. Also fix headings sometimes not including the proper heading level in the markup;

= 1.9.1 =
* Fixed related posts block sometimes causing slowdowns in the site editor;
* Minor block template fixes;
* Added additional sort options to the query block;
* Added new format tool to insert a current date shortcode with configurable date formats. Perfect for all your copyright needs;
* Fix Colours settings allowing users to save multiple colours with the same keys;
* Fix submenu block not using padding settings;
* Added toolbar button to replace images in the editor if the preview was for some reason obscured;
* Added image source size selection for Image and Featured Image blocks;
* Fix "transform to RCB" process sometimes not setting reference IDs on converted blocks.
* Also prevented the control from appearing in some scenarios where a conversion would be considered highly illegal;

= 1.9.0 =
* Fixed some block settings having inconsistent behaviour between editor and front-end;
* Performance improvements for editor experience, particularly with pages that have a large amount of Reusable Component Blocks;
* Added Bluesky social icon;
* Performance improvements for the Related Posts block to better scale for sites with posts in the thousands;
* Multisite is now supported!
* Fixed some bugs with parallax scrolling in the frontend;
* NEW! Text Style format is available, allowing users to make inline changes to text styles;
* NEW! Mixed Content Block allows for variable content insertion for RCBs, which was previously unavailable;
* NEW! Theme JSON support: themes can now use a json file to provide preset RCBs and Refoundry global settings;
* NEW! RCB now has "detach" function, can now create RCBs from selected blocks, RCB search field now has a preview;
* More styling controls added for the Tabs, Accordion, Post Terms and Slideout blocks;
* License page is now much nicer;
* We've also added a Welcome page, which is also very nice;

= 1.8.7 =
* Fix some deprecated utility function fallbacks;
* Fix RelatedPosts block sometimes breaking in the site editor if it couldn't identify what post type the current template was for;
* Small css tweak for our block panels to help inputs not seem as bunched up, and fix some rare overflows;
* Fix QueryAdvancedFilters overlay sometimes not allowing user to scroll it if site parallax was enabled;

= 1.8.6 =
* Fix issues with some non-standard elements being stripped by kses functions;
* Generally relax some kses implementations due to redundancy;
* Fix legacy author block not outputting css classes correctly;

= 1.8.5 =
* Fix issue with some blocks not properly applying custom field overrides;
* Fix issue with slider autoHeight not properly applying if the slider was initially hidden on the page during load;

= 1.8.4 =
* The free version has been unleashed upon the cosmos. Signs and portents, etc.
